// TODO: [REL-5759] change <span> to <a href="javascript:void(0)"> after getting rid of karma e2e
class ReleasesListPage {
    constructor() {
        Browser.waitFor('#releases-content');
        browser.sleep(200);
    }

    clearStatusFilter() {
        element(By.css('.release-filter-status')).click();
        element(By.$(`.release-filter-status .xl-react-link:contains('Clear all')`)).click();
        return this;
    }

    toggleSearch() {
        element(By.css('.toggle-search-filter')).click();
        return this;
    }

    searchBy(criteria) {
        element(By.css('.searchFilter')).clear();
        element(By.css('.searchFilter')).sendKeys(criteria);
        browser.sleep(1000);
        return this;
    }

    clickOnStatusFilter(criteria) {
        element(By.css('.release-filter-status')).click();
        element(By.$('.release-filter-status .react-tagsinput-input')).sendKeys(criteria);
        browser.sleep(500);
        element(By.$(`.release-filter-status .xl-react-autocomplete-suggestion div[title='${criteria}']`)).click();
        element(By.$('.filter-title:contains(Status)')).click();
        browser.sleep(500);
        return this;
    }

    selectAllCompleted() {
        return this.clearStatusFilter()
            .clickOnStatusFilter('Completed')
            .clickOnStatusFilter('Aborted');
    }

    selectAll() {
        return this.clearStatusFilter()
            .clickOnStatusFilter("Planned")
            .clickOnStatusFilter("In progress")
            .clickOnStatusFilter("Paused")
            .clickOnStatusFilter("Failed")
            .clickOnStatusFilter("Failing")
            .clickOnStatusFilter("Completed")
            .clickOnStatusFilter("Aborted");
    }

    releaseElement(releaseName) {
        Browser.waitFor(`.release:contains('${releaseName}')`);
        return element(By.$(`.release:contains('${releaseName}')`));
    }

    openReleaseByName(releaseName) {
        browser.sleep(500);
        Browser.waitForDisplayed(`.release-title:contains('${releaseName}')`);
        element(By.$(`.release-line .row-wrapper:contains('${releaseName}') a`)).click();
        return new ReleasePage();
    }

    expectReleaseAborted(title) {
        Browser.waitForDisplayed(`.release:contains('${title}')`);
        expect(element(By.$(`.release:contains('${title}')`)).isPresent()).toBe(true);
        return this;
    }

    expectReleaseStarted(title) {
        return this.expectReleaseStatus(title, 'In progress');
    }

    expectReleasePlanned(title) {
        return this.expectReleaseStatus(title, 'Planned');
    }

    expectReleaseArchived(title) {
        return this.expectReleaseStatus(title, 'Archived');
    }

    expectReleaseCompleted(title) {
        return this.expectReleaseStatus(title, 'Completed');
    }

    expectReleaseFailed(title) {
        return this.expectReleaseStatus(title, 'Failed');
    }

    expectReleaseStatus(title, status) {
        Browser.waitFor(`.release:contains('${title}')`);
        expect(element(By.$(`.release:contains('${title}') .release-status:contains('${status}')`)).isPresent()).toBe(true);
        return this;
    }

    expectNumberOfReleases(title, expectedCount) {
        const releaseSelector = `.release:contains('${title}')`;
        if (expectedCount === 1) {
            expect(element(By.$(releaseSelector)).isPresent());
        } else {
            expect(element.all(By.$(releaseSelector)).count()).toBe(expectedCount);
        }
        return this;
    }

    expectNumberOfReleasesByMonth(expectedCount) {
        expect(element.all(By.css('.release')).count()).toBe(expectedCount);
        return this;
    }

    selectReleaseWithIds(releaseIds) {
        releaseIds.forEach(id => {
            Browser.waitForDisplayed(`.release-row:has("a[href$='${id}']")`);
            browser.actions().mouseMove(element(By.$(`.release-row:has("a[href$='${id}']")`))).perform();
            element(By.$(`.release-row:has("a[href$='${id}']") [type="checkbox"]`)).click();
        });
        return this;
    }

    shiftSelectFromTo(from, to) {
        from++;
        to++;
        browser.actions().mouseMove(element(By.$(`.release-row:nth-child(${from})`))).perform();
        element(By.$(`.release-row:nth-child(${from}) [type="checkbox"]`)).click();

        browser.actions()
            .keyDown(protractor.Key.SHIFT)
            .mouseMove(element(By.$(`.release-row:nth-child(${to}) [type="checkbox"]`)))
            .click()
            .keyUp(protractor.Key.SHIFT)
            .perform();

        return this;
    }

    selectAllReleases() {
        browser.actions().mouseMove(element(By.id('selectAllCheckbox'))).perform();
        element(By.id('selectAllCheckbox')).click();
        return this;
    }

    expectSelectedReleasesLabelToBe(numberOfSelectedReleasesText) {
        expect(element(By.$(`#releases-header .filter-release-basic > .unselect-all:contains('${numberOfSelectedReleasesText}')`)).isPresent()).toBe(true);
        return this;
    }

    expectSelectedReleasesLabelToBeVisible(visible = true) {
        expect(element(By.$(`#releases-header .filter-release-basic > .unselect-all`)).isPresent()).toBe(visible);
        return this;
    }

    expectBulkActionButtonToBeVisible(buttonText) {
        expect(element(By.$(`#releases-header button:contains("${buttonText}")`)).isDisplayed()).toBeTruthy();
        return this;
    }

    clickOnAbortButton() {
        element(By.buttonText('Abort')).click();
        return this;
    }

    clickOnStartButton() {
        element(By.buttonText('Start')).click();
        return this;
    }

    confirmAction() {
        element(By.$('.modal-footer > .save')).click();
        Browser.waitFor('#toast-container');
        element(By.$('#toast-container button')).click();
        return this;
    }

    expectToSeeReleasesWithIds(releaseIds) {
        releaseIds.forEach(id => {
            const el = element(By.$(`.release-row:has("a[href$='${id}']")`));
            browser.wait(el.isPresent().then(function (presented) {
                return !presented;
            }), 3000);
            expect(el).toBePresent(true);
        });
        return this;
    }

    expectNotToSeeReleasesWithIds(releaseIds) {
        releaseIds.forEach(id => {
            const el = element(By.$(`.release-row:has("a[href$='${id}']")`));
            expect(el).toBePresent(false);
        });
        return this;
    }

    expectReleasesToBeDisplayed(releases) {
        _.forEach(releases, (present, release) => {
            if (present) {
                Browser.waitFor(`.release:contains('${release}')`);
            }
            expect(element(By.$(`.release:contains('${release}')`)).isPresent()).toBe(present);
        });
        return this;
    }

    toggleMyReleases() {
        element(By.css('.only-mine')).click();
        return this;
    }

    toggleOnlyFlagged() {
        element(By.css('.only-flagged')).click();
        return this;
    }

    // sometimes needed release will be on the second page because of the other tests
    loadMore() {
        browser.executeScript(`
            var container = $('.view-container .view');
            container.scrollTop(container.prop('scrollHeight'));
        `);
        browser.sleep(300);
        return this;
    }

}

global.ReleasesListPage = ReleasesListPage;
