class ConfigurationPage {
    constructor() {
        Browser.waitFor('#configuration');
    }

    refresh() {
        return new ConfigurationPage();
    }

    getInstance(instanceName) {
        return element(By.$(`.configuration-instance:contains('${instanceName}')`));
    }

    getType(typeName) {
        return element(By.$(`.configuration-type:contains('${typeName}')`));
    }

    openInstance(instanceName) {
        this.getInstance(instanceName).element(By.css('.open-instance a')).click();
        return new ConfigurationInstancePage;
    }

    addNewInstance(typeName) {
        this.getType(typeName).element(By.css('.new-instance .button')).click();
        return new ConfigurationInstancePage();
    }

    deleteInstance(instanceName) {
        this.getInstance(instanceName).element(By.css('.delete-instance')).click();
        return this;
    }

    expectTypeDisplayed(typeName) {
        expect(this.getType(typeName)).toBeDisplayed();
        return this;
    }

    expectInstanceDisplayed(instanceName) {
        expect(this.getInstance(instanceName)).toBeDisplayed();
        return this;
    }

    expectNoInstance(instanceName) {
        expect(this.getInstance(instanceName).isPresent()).toBe(false);
        return this;
    }

    expectErrorDisplayed() {
        expect(element(By.css(".modal"))).toBeDisplayed();
        element(By.css(".modal .close")).click();
        return this;
    }
}

class ConfigurationInstancePage {
    constructor() {
        Browser.waitFor('#configuration-instance');
    }

    setTextField(fieldName, fieldValue) {
        element(By.$(`#${fieldName}`)).clear();
        element(By.$(`#${fieldName}`)).sendKeys(fieldValue);
        return this;
    }

    expectFieldToBe(fieldName, fieldValue) {
        expect(element(By.$(`#${fieldName}`)).getAttribute('value')).toBe(fieldValue);
        return this;
    }

    expectFieldToNotContain(fieldName, fieldValue) {
        expect(element(By.$(`#${fieldName}`)).getAttribute('value')).not.toContain(fieldValue);
        return this;
    }

    save() {
        $$("button[data-test='submit']").click();
        return this;
    }

    test() {
        $$("button[data-test='testButton']").click();
        return this;
    }

    expectTestButtonToBeDisabled() {
        expect($$("button[data-test='testButton']").first().isEnabled()).toBe(false);
        return this;
    }

    expectElementToContain(elementCss, value) {
        expect(element(By.css(elementCss)).getText()).toContain(value);
        return this;
    }

    expectToBeSaved() {
        expect(element(By.css(".last-saved"))).toBeDisplayed();
        return this;
    }
}

global.ConfigurationPage = ConfigurationPage;
global.ConfigurationInstancePage = ConfigurationInstancePage;
