class Page {

    static openTasksList(filter) {
        if (filter) {
            const url = this.appendFilterQueryString('#/tasks', filter);
            browser.setLocation(url);
            // this.softReload(); //-> needed to implement here as well?!
        } else {
            browser.setLocation('/tasks');
        }
        return new TasksListPage();
    }

    static openMyTasks() {
        return Page.openTasksList();
    }

    static openSingleTask(taskId, showDetails = false) {
        browser.setLocation(`/tasks/${taskId}?showDetails=${showDetails}`);
        return new SingleTaskPage();
    }

    static openReleasesList(filter) {
        const url = this.appendFilterQueryString('releases', filter);
        browser.setLocation(url);
        return new ReleasesListPage();
    }

    static openTemplatesList(filter) {
        let url = '/templates';
        if (filter) {
            url += `?has_filter&filter=${filter}`;
        }
        browser.setLocation(url);
        return new TemplatesListPage();
    }

    static openRelease(releaseId) {
        browser.setLocation(`/releases/${releaseId}`);
        return new ReleasePage();
    }

    static openTemplate(templateId) {
        browser.setLocation(`/templates/${templateId}`);
        return new ReleasePage();
    }

    static openReleaseOnGanttPage(releaseId) {
        browser.setLocation(`/releases/${releaseId}`);
        return new ReleaseGanttPage();
    }

    static openReleaseOnGridPage(releaseId) {
        browser.setLocation(`/releases/${releaseId}`);
        return new ReleaseGridPage();
    }

    static openReleaseOnVariablesPage(releaseId) {
        browser.setLocation(`/releases/${releaseId}/variables`);
        return new VariablesPage('#release-variables');
    }

    static appendFilterQueryString(url, filter) {
        if (filter) {
            const queryString = ((() => {
                let result = [];
                for (const key in filter) {
                    const value = filter[key];
                    if (value) {
                        result.push(value === true ? `${key}` : `${key}=${encodeURIComponent(value)}`);
                    }
                }
                return result;
            })()).join('&');
            if (queryString) {
                url += `?${queryString}`;
            }
        }

        return url;
    }

    static openSmtp() {
        browser.setLocation('/smtp');
        return new SmtpPage();
    }

    static openPermissions() {
        browser.setLocation('/permissions');
        return new PermissionsPage();
    }

    static openGeneralSettings() {
        browser.setLocation('/general-settings');
        return new GeneralSettingsPage();
    }

    static openNotificationSettings() {
        browser.setLocation('/notification-settings');
        return new NotificationSettingsPage();
    }

    static openGlobalVariables() {
        browser.setLocation('/global-variables');
        return new VariablesPage('#global-variables');
    }

    static openRoles() {
        browser.setLocation('/roles');
        return new RolesPage();
    }

    static openUsers() {
        browser.setLocation('/users');
        return new UsersPage();
    }

    static openTaskAccess() {
        browser.setLocation('/task-access');
        return new TaskAccessPage();
    }

    static openProfile() {
        browser.setLocation('/profile');
        return new ProfilePage();
    }

    static openNotificationSettings() {
        browser.setLocation('/notification-settings');
        return new NotificationSettingsPage();
    }

    static openRisks() {
        browser.setLocation('/risks');
        Browser.waitForDisplayed('.risk-profile-list', 3000); // wait till risk profiles is loaded
        return new RisksPage();
    }

    static clearClientSettings() {
        return Browser.executeVoidScript(function () {
            const $injector = angular.element('body').injector();
            const $rootScope = $injector.get('$rootScope');
            return $rootScope.$apply(function () {
                const ClientSettings = $injector.get('ClientSettings');
                return ClientSettings.clear();
            });
        });
    }

    static openCalendar() {
        browser.setLocation('/calendar');
        return new CalendarPage();
    }

    static openConfiguration() {
        browser.setLocation('/configuration');
        return new ConfigurationPage();
    }

    static openReleaseValueStream(filter) {
        let url = '/release-value-stream';
        if (filter) {
            url += `?has_filter&${filter}`;
        }
        browser.setLocation(url);
        return new ReleaseValueStreamPage();
    }

    static openDashboardReports(filter) {
        let url = '/dashboard';
        if (filter) {
            url += `?has_filter&${filter}`;
        }
        browser.setLocation(url);
        return new ReportDashboardPage();
    }

    static openTemplatesInFolder(folderId) {
        browser.setLocation(`/folders/${folderId}/templates`);
        return new TemplatesListPage();
    }

    static openReleasesInFolder(folderId) {
        browser.setLocation(`/folders/${folderId}/releases`);
        return new ReleasesListPage();
    }

    static openPermissionsInFolder(folderId) {
        browser.setLocation(`/folders/${folderId}/permissions`);
        return new FoldersPermissionsPage();
    }

}

global.Page = Page;
