class XlWidgetAutocomplete {
    constructor(selector) {
        this.widget = element(By.$(`${selector}`));
        this.input = element(By.$(`${selector} input:visible`));
        Browser.scrollTo(By.$(`${selector}`));
    }

    focus() {
        this.input.click();
        return this;
    }

    expectOptions(options) {
        this.getOptions().all(By.css("li")).then(function (items) {
            expect(items.length).toBe(options.length);
            return items.map((item, i) =>
                expect(item.getText()).toContain(options[i]));
        });
        return this;
    }

    expectMinimumOptions(options) {
        this.getOptions().all(By.css("li")).getText().then(function(itemsList) {
            for (const option in options) {
                expect(itemsList).toContain(options[option]);
            }
        });
        return this;
    }

    getValue() {
        return this.input.getAttribute('value');
    }

    expectValue(value) {
        expect(this.input.getAttribute('value')).toContain(value);
        return this;
    }

    expectNoValue() {
        expect(this.input.getAttribute('value')).toEqual('');
        return this;
    }

    enter(text, waitForFilteringApplied = true) {
        if (waitForFilteringApplied) {
            this.getOptions().all(By.css("li")).count().then(numberBefore => {
                    this.input.sendKeys(text);
                    browser.sleep(500);
                    return Browser.wait(() => {
                        return this.getOptions().all(By.css("li")).count().then(numberAfter => numberAfter !== numberBefore);
                    }
                );
                }
            );
        } else {
            this.input.sendKeys(text);
        }
        return this;
    }

    select(name, wait = false) {
        if (wait) {
            Browser.waitFor(`li:contains('${name}')`, 5000);
        }
        this.getOptions().all(By.$(`li:contains('${name}')`)).first().click();
        return this;
    }

    getOptions() {
        if (this.options) {
            return this.options;
        } else {
            this.focus();
            return this.options = element.all(By.css("ul.xl-components.xl-widget-autocomplete"));
        }
    }

    clearByKeys() {
        this.input.clear();
        return this;
    }

    clearByButton() {
        this.widget.element(By.$(".xl-btn-close")).click();
        return this;
    }
}

class XlDipListOfCi extends XlWidgetAutocomplete {
    constructor(selector) {
        super(selector);
        this.selectedList = element(By.$(`${selector} ul[ui-sortable]`));
    }

    expectSelected(selected) {
        this.selectedList.all(By.css("li")).then(function (items) {
            expect(items.length).toBe(selected.length);
            return items.map((item, i) =>
                expect(item.getText()).toContain(selected[i]));
        });
        return this;
    }

    remove(name) {
        this.selectedList.element(By.$(`li:contains('${name}') .xl-btn-close`)).click();
        return this;
    }
}

class XlDipInteger {
    constructor(selector) {
        this.input = element(By.$(`${selector} .editor input`));
    }

    clear() {
        this.input.clear();
        return this;
    }

    blur() {
        Browser.clickElseWhere();
        return this;
    }

    focus() {
        this.input.click();
        return this;
    }

    enter(text) {
        this.input.sendKeys(text);
        return this;
    }

    set(text) {
        this.focus();
        this.clear();
        this.enter(text);
        return this;
    }
}

class XlDipCheckbox {
    constructor(selector) {
        this.input = element(By.$(`${selector} input[type=checkbox]`));
    }

    check(value = true) {
        let target = this.input;
        return target.isSelected().then(function (selected) {
            if (selected !== value) {
                return target.click();
            }
        });
    }
}

global.XlWidgetAutocomplete = XlWidgetAutocomplete;
global.XlDipListOfCi = XlDipListOfCi;
global.XlDipInteger = XlDipInteger;
global.XlDipCheckbox = XlDipCheckbox;
