class TemplateHistoryPage {
    constructor() {
        Browser.waitFor('#template-history');
    }

    revertTemplate(templateActionMessage) {
        element(by.css(`.template-history-item:contains('${templateActionMessage}') .revert-action`)).click();
        return this;
    }

    searchByUsername(username) {
        element(By.css('.user-filter input')).clear();
        element(By.css('.user-filter input')).sendKeys(username);
        browser.sleep(1000);
        return this;
    }

    setFromFilterDate(from = null) {
        if (from !== null) {
            new DateTimePicker('.from-date .date-editor')
                .setDateTime(from);
        }
        return this;
    }

    setToFilterDate(to = null) {
        if (to !== null) {
            new DateTimePicker('.to-date .date-editor')
                .setDateTime(to);
        }
        return this;
    }

    clearDateFilter() {
        new DateTimePicker('.from-date .date-editor')
            .removeDate();
        new DateTimePicker('.to-date .date-editor')
            .removeDate();
        return this;
    }

    checkQueryParams(queryParams) {
        const browserWait = (condition) => {
            browser.wait(condition, 3000);
        };
        _.forEach(queryParams, (value, key) => {
            if (_.isBoolean(value)) {
                browserWait(EC.urlContains(key));
            } else if (_.isArray(value)) {
                _.forEach(value, (v) => {
                    browserWait(EC.urlContains(`${key}=${v}`));
                });
            } else {
                browserWait(EC.urlContains(`${key}=${value}`));
            }
        });
        return this;
    }
}

global.TemplateHistoryPage = TemplateHistoryPage;
