class LoginPage {
    static login(login, password) {
        element(By.model('loginInfo.login')).clear();
        element(By.model('loginInfo.login')).sendKeys(login);
        element(By.model('loginInfo.password')).sendKeys(password);
        element(By.css('#login .login-button button')).click();
        browser.waitForAngular();
        return this;
    }

    static manuallyLogout() {
        element(By.css('.current-user .dropdown-button')).click();
        element(By.css('.logout.action')).click();
        browser.waitForAngular();
        return this;
    }

    static logout() {
        browser.setLocation('/login');
        browser.waitForAngular();
        TaskPolling.waitForPollRequest();
        return this;
    }

    static expectLoginDisallowed() {
        expect(browser.getCurrentUrl()).toMatch(/login/);
        expect(element(By.$('.error:visible')).getText()).toContain("Permission 'login' is not granted to you.");
        return this;
    }

    static expectToBeLogged(username) {
        expect(element(By.css('.current-user')).getText()).toContain(`Logged in as ${username}`);
        return this;
    }
}


global.LoginPage = LoginPage;
