class ActivityLogsPage {
    static openActivityLogs(releaseId, filter = {}) {
        let url = Page.appendFilterQueryString(`/releases/${releaseId}/logs`, filter);
        browser.setLocation(url);
        return new ActivityLogsPage();
    }

    constructor() {
        Browser.waitFor('#logs');
    }

    toggleFilterCategories() {
        element(By.css('#release-header .filters button')).click();
        return this;
    }

    toggleLog(logName) {
        element(By.$(`#filter-container label:contains('${logName}') input`)).click();
        return this;
    }

    expectCountToBe(num) {
        expect(element.all(By.css(".log")).count()).toEqual(num);
        return this;
    }

    waitForCountToBe(num) {
        Browser.wait(() => element.all(By.css(".log")).count().then(count => count === num),
            `waiting for number of logs to be ${num}`);
        return this;
    }

    expectContainingLog({user, msg, date, index}) {
        let selector = ".log";
        if (index !== undefined) {
            selector += `:eq(${index})`;
        }
        if (user) {
            selector += `:contains('${user}')`;
        }
        if (msg) {
            selector += `:contains('${msg}')`;
        }

        expect(element(By.$(selector))).toBeDisplayed();

        if (date) {
            Dates.expectContainingDate(By.$(selector), 'medium', date);
        }

        return this;
    }

    setSearchFilter(filterText) {
        element(By.model('filters.filter')).clear();
        element(By.model('filters.filter')).sendKeys(filterText);
        return this;
    }

    expectSearchFilter(filterText) {
        expect(element(By.model('filters.filter')).getAttribute('value')).toBe(filterText);
        return this;
    }

    toggleCategories(categories) {
        element(By.css('#logs .filters .dropdown-button')).click();
        for (let category of categories) {
            element(By.$(`input[ng-model='filters.${category}']`)).click();
        }
        element(By.css('#logs .filters .dropdown-button')).click();
        return this;
    }

    toggleDateSort() {
        element(By.css('.logs-header .date')).click();
        return this;
    }
}

global.ActivityLogsPage = ActivityLogsPage;
