class VariablesEditor {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.variablesEditor = element(By.$(this.path));
    }

    expectVariablesDisplayed(variables) {
        expect(this.variablesEditor.all(By.css(".form-group")).count()).toBe(_.keys(variables).length);
        this.variablesEditor.all(By.css(".form-group")).then(elements =>
            _.zip(_.toPairs(variables), elements).map(([[name, value], item]) =>
                (expect(item.getText()).toContain(name),
                    expect(item.element(By.$("input")).getAttribute('value')).toEqual(value)))
        );
        return this;
    }

    setVariableValue(key, value) {
        new InlineEditor(`${this.path} .form-group:contains('${key}') div[inline-text-editor]`)
            .set(value);
        return this;
    }

    getStringListField(key) {
        return new XlrListStringWithVariables(`${this.path} #${key}`);
    }
}


global.VariablesEditor = VariablesEditor;