class ReleasesListPage {
    constructor() {
        Browser.waitFor('.release');
    }

    toggleFilterDropDown() {
        element(By.$('.release-filter .btn:first-child')).click();
        return this;
    }

    toggleSearch() {
        element(By.css('.toggle-search-filter')).click();
        return this;

    }

    clickOnFilter(criteria) {
        element(By.$(`.release-filter a:contains('${criteria}')`)).click();
        return this;
    }

    releaseElement(releaseName) {
        return element(By.$(`.release:contains('${releaseName}')`));
    }

    openReleaseByName(releaseName) {
        element(By.$(`.release-title:contains('${releaseName}')`)).click();
        return new ReleasePage();
    }

    expectReleaseAborted(title) {
        expect(element(By.$(`.release:contains('${title}')`)).isPresent()).toBe(true);
        return this;
    }

    expectReleaseStarted(title) {
        return this.expectReleaseStatus(title, 'In progress');
    }

    expectReleasePlanned(title) {
        return this.expectReleaseStatus(title, 'Planned');
    }

    expectReleaseArchived(title) {
        return this.expectReleaseStatus(title, 'Archived');
    }

    expectReleaseCompleted(title) {
        return this.expectReleaseStatus(title, 'Completed');
    }

    expectReleaseFailed(title) {
        return this.expectReleaseStatus(title, 'Failed');
    }

    expectReleaseStatus(title, status) {
        expect(element(By.$(`.release:contains('${title}') .release-status:contains('${status}')`)).isPresent()).toBe(true);
        return this;
    }

    expectNumberOfReleases(title, expectedCount) {
        let releaseSelector = `.release:contains('${title}')`;
        expect(element.all(By.$(releaseSelector)).count()).toBe(expectedCount);
        return this;
    }

    expectNumberOfReleasesByMonth(expectedCount) {
        expect(element.all(By.css('.release')).count()).toBe(expectedCount);
        return this;
    }
}

global.ReleasesListPage = ReleasesListPage;
