class ReleaseGridPage {
    constructor() {
        Browser.waitFor('.ui-grid-contents-wrapper');
    }

    setHeaderFilter(columnTitle, valueToFilter) {
        let filter = element(By.$(`.ui-grid-header-cell:contains(${columnTitle}) input`));
        filter.clear();
        filter.sendKeys(valueToFilter);
        return this;
    }

    setDateHeaderFilter(columnTitle, valueToFilter) {
        new DateTimePicker(`.ui-grid-header-cell:contains(${columnTitle}) .date-editor`).setDate(valueToFilter);
        return this;
    }

    expectRowCountToBe(cellCount) {
        expect(element.all(By.css('.ui-grid-canvas .name-cell')).count()).toBe(cellCount);
        return this;
    }

    expectExpandedRowCountToBe(rowCount) {
        expect(element.all(By.css(".ui-grid-canvas .expand-icon")).count()).toBe(rowCount);
        return this;
    }

    collapseNthRowByItem(rowIndex) {
        Browser.waitFor(".ui-grid-canvas .ui-grid-row .expand-icon");
        //Selector is really ugly, but couldn't find a better way to do this
        element(By.$(`.ui-grid-canvas div[ng-click='grid.appScope.ctrl.gridApi.treeBase.toggleRowTreeState(row)']:eq(${rowIndex})`)).click();
        return this;
    }

    expectItemWithTitleStatusAndDates(title, status, startDate, endDate) {
        expect(element(By.$(`.ui-grid-canvas .ui-grid-row:contains(${title}):contains(${status}):contains(${startDate}):contains(${endDate})`))).toBePresent();
        return this;
    }

    expectItemWithTitle(title) {
        expect(element(By.$(`.ui-grid-canvas .name-cell:contains(${title})`))).toBePresent();
        return this;
    }

    openItemDetails(itemTitle, detailsCallback) {
        Browser.waitFor(`.ui-grid-canvas .name-cell-title:contains(${itemTitle})`);
        element(By.$(`.ui-grid-canvas .name-cell-title:contains(${itemTitle})`)).click();
        return detailsCallback();
    }

    openContextMenu(task) {
        element(By.$(`.ui-grid-cell-contents:contains(${task}) .context-menu-button`)).click();
        return this;
    }

    callMenuItemForTask(item, task) {
        this.openContextMenu(task);
        return element(By.$(`#context-menu-container a:contains('${item}')`)).click();
    }

    expectDisabledContextMenuItem(item, task) {
        this.openContextMenu(task);
        expect(element.all(By.$(`#context-menu-container a:contains('${item}')[disabled]`)).count()).toBe(1);
        return this;
    }

    callSubMenuItemForTask(item, subitem, task) {
        return this.callMenuItemForTask(item, task).then(() => element(By.$(`.dropdown-submenu a:contains('${subitem}')`)).click());
    }

    hasTaskAssignedTo(task, user) {
        Browser.waitFor(`.ui-grid-row:contains('${task}') span:contains('${user}')`, 3000);
        expect(element(By.$(`.ui-grid-row:contains('${task}') span:contains('${user}')`))).toBePresent();
        return this;
    }

    hasTaskStatus(task, status) {
        Browser.waitFor(`.ui-grid-row:contains('${task}') span:contains('${status}')`, 3000);
        expect(element(By.$(`.ui-grid-row:contains('${task}') span:contains('${status}')`))).toBePresent();
        return this;
    }

    hasTaskIcon(task, icon) {
        expect(element(By.$(`.ui-grid-row:contains('${task}') .${icon}`))).toBePresent();
        return this;
    }

    expectTaskRowCountToBe(task, cellCount) {
        let filter = (elem, index) => elem.getText().then(text => text === task);
        expect(element.all(By.css(".name-cell-title")).filter(filter).count()).toBe(cellCount);
        return this;
    }

    clickModalPrimaryButton() {
        return element(By.$(".modal-content .primary")).click();
    }

    setModalTextAndClick(text) {
        element(By.$('.modal-body textarea')).sendKeys(text);
        return this.clickModalPrimaryButton();
    }

    start() {
        element(By.css('.start-release')).click();
        element(By.$(".modal:visible .button:contains('Start')")).click();
        return this;
    }

    abort() {
        element(By.$('.abort-release')).click();
        element(By.$('.modal .continue')).click();
        return this;
    }

    expectStatus(status) {
        expect(element(By.$(`#release.${status}`)).isPresent()).toBe(true);
        return this;
    }

    openReleaseFlowAndWaitForGrid() {
        element(By.css('#release-header .subpage-links button')).click();
        element(By.$("#subpages-container div:contains('Release flow')")).click();
        return new ReleaseGridPage();
    }

    selectTask(task) {
        Browser.waitFor(`.ui-grid-cell-contents:contains(${task}) .item-selector`, 3000);
        element(By.$(`.ui-grid-cell-contents:contains(${task}) .item-selector`)).click();
        return this;
    }

    expectSelectedTasksCounter(text) {
        expect(element(By.$(`.actions-bar-counter`)).isPresent()).toBe(true);
        expect(element(By.$(`.actions-bar-counter`)).getText()).toEqual(text);
        return this;
    }

    clearSelection() {
        element(By.$('.actions-bar-clear')).click();
        return this;
    }

    deleteSelectedTasks() {
        element(By.$('.remove-action')).click();
        return this;
    }

    clickOnMoreActions() {
        element(By.$('.actions-bar-container .more-actions')).click()
        return this;
    }

    clickCompleteAction(){
        element(By.$('.actions-bar-container .complete-action')).click();
        return this;
    }

    clickSkipAction(){
        element(By.$('.actions-bar-container .skip-action')).click();
        return this;
    }

    clickReopenAction(){
        element(By.$('.actions-bar-container .reopen-action')).click();
        return this;
    }

    clickFailAction(){
        element(By.$('.actions-bar-container .fail-action')).click();
        return this;
    }

    clickRetryAction(){
        element(By.$('.actions-bar-container .retry-action')).click();
        return this;
    }

    assignSelectedTasks(owner, team) {
        element(By.$('.assign-action')).click();
        const ownerSelector = new UserInlineEditor('.task-owner');
        ownerSelector.focus();
        ownerSelector.enter(owner);
        element(By.$('.principal')).click();
        const teamSelector = new AutoCompleteInlineEditor('.task-team');
        teamSelector.focus();
        teamSelector.enter(team);
        return this;
    }

    insertCommentForAction(comment) {
        element(By.$('.actions-modal-comment')).click();
        element(By.$('.actions-modal-comment')).sendKeys(comment);
        return this;
    }

    commentSelectedTasks(comment) {
        element(By.$('.add-comment-action')).click();
        this.insertCommentForAction(comment);
        return this;
    }


    confirmAction() {
        Browser.waitFor('.modal-footer .primary', 3000);
        element(By.$('.modal-footer .primary')).click();
        browser.driver.sleep(1000);
        return this;
    }
}

global.ReleaseGridPage = ReleaseGridPage;
