class Dates {

    static getFormattedDate(format, date) {
        if (Array.isArray(date)) {
            date = new Date(date);
        }
        return browser.executeScript(function () {
                date = arguments[0];
                format = arguments[1];
                let $injector = angular.element('body').injector();
                let dateFilter = $injector.get('dateFilter');
                return dateFilter(date, format);
            }
            , date, format);
    }

    static expectContainingDate(inputLocator, format, date) {
        return this.getFormattedDate(format, date).then(formattedDate => {
                expect(element(inputLocator).getText()).toContain(formattedDate);
            }
        );
    }

    static expectInputContainingDate(inputLocator, format, date) {
        return this.getFormattedDate(format, date).then(formattedDate => {
                expect(element(inputLocator).getAttribute('value')).toContain(formattedDate);
            }
        );
    }
}

global.Dates = Dates;
