class LoginPage {
    static login(login, password) {
        element(By.model('loginInfo.login')).clear();
        element(By.model('loginInfo.login')).sendKeys(login);
        element(By.model('loginInfo.password')).sendKeys(password);
        element(By.css('#login .login-button button')).click();
        browser.waitForAngular();
        // if is releases list page => waitForReleasesLoaded()
        /*if(browser.getCurrentUrl().indexOf('releases') !== -1)
            ReleasesListPage().waitFor('.releases-list-loaded:visible');*/
        return this;
    }

    static manuallyLogout() {
        element(By.css('top-toolbar .avatar-wrapper')).click();
        element(By.$('.top-toolbar-avatar-menu:contains("Log out")')).click();
        browser.waitForAngular();
        return this;
    }

    static logout() {
        browser.setLocation('/login');
        browser.waitForAngular();
        TaskPolling.waitForPollRequest();
        return this;
    }

    static expectLoginDisallowed() {
        expect(browser.getCurrentUrl()).toMatch(/login/);
        expect(element(By.$('.error-content > span:visible')).getText()).toContain("You do not have 'login' permission.");
        return this;
    }

    static expectToBeLogged(username) {
        element(By.css('top-toolbar .avatar-wrapper')).click();
        expect(element(By.css('.top-toolbar-avatar-menu')).getText()).toContain(username);
        return this;
    }
}

global.LoginPage = LoginPage;
