class TaskAccessPage {
    constructor() {
        Browser.waitFor('#task-access');
    }

    setTaskAvailableToAllUsers(taskType, available) {
        let checkBox = element(By.$(`#task-access table tr:contains('${taskType}') input[type=checkbox]`));
        return checkBox.isSelected().then(function (selected) {
            if (selected !== available) {
                return checkBox.click();
            }
        });
    }

    save() {
        element(By.$('.action-toolbar-wrapper button:contains("Save")')).click();
        return Browser.waitFor('.saved-text');
    }
}

global.TaskAccessPage = TaskAccessPage;
