class GeneralSettingsPage {
    constructor() {
        Browser.waitFor('#general-settings');
    }

    setWarningThreshold(value) {
        FormUtil.setField('#warningThreshold', value);
        return this;
    }

    setErrorThreshold(value) {
        FormUtil.setField('#errorThreshold', value);
        return this;
    }

    setCriticalPhaseThreshold(value) {
        FormUtil.setField('#criticalPhaseThreshold', value);
        return this;
    }

    setPollingInterval(value) {
        FormUtil.setField('#pollingInterval', value);
        return this;
    }

    setInstanceName(value) {
        FormUtil.setField('#header-form-title', value);
        return this;
    }

    setHeaderColor(num) {
        element(By.$('.toggle-picker')).click();
        element(By.$(`.simplecolorpicker div:nth-child(${num})`)).click();
        return this;
    }

    expectWarningThreshold(value) {
        expect(element(By.id('warningThreshold')).getAttribute('value')).toBe(value);
        return this;
    }

    expectErrorThreshold(value) {
        expect(element(By.id('errorThreshold')).getAttribute('value')).toBe(value);
        return this;
    }

    expectCriticalPhaseThreshold(value) {
        expect(element(By.id('criticalPhaseThreshold')).getAttribute('value')).toBe(value);
        return this;
    }

    expectPollingInterval(value) {
        expect(element(By.id('pollingInterval')).getAttribute('value')).toBe(value);
        return this;
    }

    expectArchivingSettingDeleteInterval(value) {
        expect(element(By.id('archivingSettingsAge')).getAttribute('value')).toBe(`${value}`);
        return this;
    }

    expectArchivingSettingDeleteIntervalUnit(value) {
        element
            .all(By.options('archivingSettingsAgeUnit'))
            .filter((elem) => elem.getAttribute('selected'))
            .then((elements) => expect(elements[0].getText()).toBe(value));
        return this;
    }

    expectInstanceName(value) {
        Browser.waitFor('.header-environment-name');
        expect(element(By.$('.header-environment-name')).getText()).toContain(value);
        return this;
    }

    expectHeaderColor(value) {
        let some = element(By.$('.main-header-wrapper')).getCssValue('border-bottom-color');
        expect(value).toBe(some);
        return this;
    }

    setArchivingSettingsDeleteIntervalUnit(value) {
        element
            .all(By.options('archivingSettingsAgeUnit'))
            .filter((elem) => elem.getText().then((text) => text === value))
            .then((elements) => elements[0].click());
        return this;
    }

    setArchivingSettingsDeleteInterval(value) {
        FormUtil.setField('#archivingSettingsAge', value);
        return this;
    }

    save() {
        element(By.css('.submit')).click();
        Browser.waitFor('.last-saved');
        return this;
    }

    refresh() {
        Browser.softReload();
        return this;
    }
}

global.GeneralSettingsPage = GeneralSettingsPage;
