class DipSetString {
    constructor(path) {
        this.path = path;
        Browser.waitFor(this.path);
        this.setString = element(By.$(this.path));
        this.inputClass = '.dip-input input';
    }

    setInput(text) {
        this.clearInput();
        this.setString.element(By.css(this.inputClass)).sendKeys(text);
        return this;
    }

    focus(selector) {
        this.setString.element(By.css(selector)).click();
        return this;
    }

    clearInput() {
        this.setString.element(By.css(this.inputClass)).clear();
        return this;
    }

    add(text) {
        this.setInput(text);
        this.setString.element(By.css(".xl-btn-add")).click();
        return this;
    }

    removeFirstItem() {
        this.setString.all(By.$("li .xl-btn-close:visible")).first().click();
        return this;
    }

    expectAddIsDisabled() {
        expect(this.setString.element(By.$(".xl-btn-add:disabled"))).toBeDisplayed();
        return this;
    }

    expectAddIsEnabled() {
        expect(this.setString.element(By.$(".xl-btn-add"))).toBeDisplayed();
        return this;
    }

    expectInputInvisible() {
        expect(this.setString.element(By.$(".input"))).toBePresent(false);
        return this;
    }

    getItems() {
        return this.setString.all(By.css(".xl-dip-set ul li")).filter(elem => elem.isDisplayed());
    }

    shouldHaveSize(expectedSize) {
        expect(this.getItems().count()).toBe(expectedSize, `Should contain ${expectedSize} item(s)`);
        return this;
    }

    shouldHaveItems(expectedItems) {
        this.shouldHaveSize(expectedItems.length);
        let iterable = this.getItems();
        for (let i = 0; i < iterable.length; i++) {
            let item = iterable[i];
            expect(item.getText()).toContain(expectedItems[i]);
        }
        return this;
    }
}


global.DipSetString = DipSetString;
