import {ReportsPage} from "./reports-page";

class ReportDashboardPage extends ReportsPage {
    cardSize = {
        short: 'short',
        big: 'big',
        bigger: 'bigger'
    };

    static ids = {
        completedReleases: 'completed-releases',
        longestTaskType: 'longest-task-types',
        averageReleaseDuration: 'avg-release-duration',
        averageTaskDuration: 'avg-task-duration',
        taskEfficiency: 'task-efficiency',
        timeSpent: 'time-spent',
        releaseEfficiency: 'release-efficiency',
        numberOfReleases: 'number-of-releases',
        longestReleases: 'longest-releases',
        averageReleaseDurationOverTime: 'avg-release-duration-over-time',
        longestPhases: 'longest-phases',
        longestTasks: 'longest-tasks'
    };

    constructor() {
        super();
        Browser.waitFor('#report');
    }

    downloadReport(id) {
        element(By.$(this.generateExportButtonPath(id))).click();
        Download.expectDownloadAt('export/report/');
        return this;
    }

    expectMenuDisplayed() {
        return super.expectMenuDisplayed('Dashboard');
    }

    expectCompletedReleasesTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.completedReleases, 'Completed releases');
    }

    expectCompletedReleasesContent(content, toEqual = true) {
        return this.expectShortContentToBePresent(ReportDashboardPage.ids.completedReleases, content, toEqual);
    }

    expectLongestTaskTypeTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.longestTaskType, 'Longest task type');
    }

    expectLongestTaskTypeContent(content, toEqual = true) {
        return this.expectShortContentToBePresent(ReportDashboardPage.ids.longestTaskType, content, toEqual);
    }

    expectAvgReleaseDurationTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.averageReleaseDuration, 'Avg. release duration');
    }

    expectAvgReleaseDurationContent(content, toEqual = true) {
        return this.expectShortContentToBePresent(ReportDashboardPage.ids.averageReleaseDuration, content, toEqual);
    }

    expectAvgTaskDurationTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.averageTaskDuration, 'Avg. task duration');
    }

    expectAvgTaskDurationContent(content, toEqual = true) {
        return this.expectShortContentToBePresent(ReportDashboardPage.ids.averageTaskDuration, content, toEqual);
    }

    expectTaskEfficiencyTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.taskEfficiency, 'Task efficiency');
    }

    expectTimeSpentTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.timeSpent, 'Time spent');
    }

    expectReleaseEfficiencyTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.releaseEfficiency, 'Release efficiency');
    }

    expectNumberOfReleasesTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.numberOfReleases, 'Number of releases');
    }

    expectTop10LongestReleasesTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.longestReleases, 'Top 10 longest releases');
    }

    expectAverageReleaseDurationTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.averageReleaseDurationOverTime, 'Average release duration over time');
    }

    expectTop10LongestPhasesTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.longestPhases, 'Top 10 longest phases');
    }

    expectTop10LongestTasksTitle() {
        return this.expectTitleToBePresent(ReportDashboardPage.ids.longestTasks, 'Top 10 longest tasks');
    }

    expectExportButton(id) {
        // expect export text
        expect(element(
            By.$(this.generateExportButtonPath(id)))
        ).toBePresent();
        // expect export icon
        element(
            By.$(`${this.generateTileTitlePath(id, this.cardSize.bigger)} a i`)
        ).getAttribute('class').then(cls => expect(cls).toBe('export-icon'));
        return this;
    }

    expectShortContentToBePresent(id, content, toEqual) {
        if (toEqual) {
            expect(element(By.$(`#${id} .card-content div tile-content:contains('${content}')`))).toBePresent();
        } else {
            expect(element(By.$(`#${id} .card-content div tile-content`)).getText()).not.toEqual(content);
        }
        return this;
    }

    expectTitleToBePresent(id, title) {
        expect(element(By.$(`${this.generateTileTitlePath(id)} tile-title:contains('${title}')`))).toBePresent();
        return this;
    }

    generateExportButtonPath(id) {
        return `${this.generateTileTitlePath(id)} a:contains('Export')`;
    }

    generateTileTitlePath(id) {
        return `#${id} .card-title`;
    }
}

global.ReportDashboardPage = ReportDashboardPage;