export class ReportsPage {
    static timeFrame = {
        last30Days: {id: 'LAST_MONTH', title: 'Last 30 days'},
        last3Months: {id: 'LAST_THREE_MONTHS', title: 'Last 3 months'},
        last6Months: {id: 'LAST_SIX_MONTHS', title: 'Last 6 months'},
        lastYear: {id: 'LAST_YEAR', title: 'Last year'},
        range: {id: 'RANGE', title: 'Range'}
    };

    expectMenuDisplayed(title) {
        expect(element(By.$(`#main-menu button:contains('${title}')`))).toBePresent();
        return this;
    }

    expectTimeFrame(timeFrame) {
        expect(element(By.$(`#reports-header .actions .time-frame .active`)).getText()).toBe(timeFrame.title);
        expect(element(By.$(`#reports-header .dates .from-date .date-filter-editor .date-picker-holder`)).getText()).toBe(timeFrame.title);
        return this.expectUrlParamsToBe({has_filter: true, timeFrame: timeFrame.id});
    }

    expectUrlParamsToBe(params) {
        Browser.expectUrlParams(params);
        return this;
    }

    expectTags(tags, timeFrame = ReportsPage.timeFrame.last6Months) {
        return this.expectUrlParamsToBe({has_filter: true, timeFrame: timeFrame.id, tags});
    }

    selectTimeFrame(timeFrame) {
        element(By.$(`#reports-header .actions .time-frame button:contains('${timeFrame.title}')`)).click();
        return this;
    }

    addTags(...tags) {
        let tagEditor = new TagEditor('.tags');
        for (let tag of tags) {
            tagEditor.addTag(tag);
        }
        return this;
    }

    removeTags(...tags) {
        let tagEditor = new TagEditor('.tags');
        for (let tag of tags) {
            tagEditor.removeTag(tag);
        }
        return this;
    }

    setFromDate(date) {
        const dateTimePicker = new DateTimePicker('.from-date .date-editor');
        dateTimePicker.setDateTime(date);
        return this;
    }

    setToDate(date) {
        const dateTimePicker = new DateTimePicker('.to-date .date-editor');
        dateTimePicker.setDateTime(date);
        return this;
    }
}

global.ReportsPage = ReportsPage;