export default class FolderPermissionsPage {

    constructor() {
        cy.get('#permissions .table').should('be.visible');
    }

    removePermission(permission, team) {
        cy.get(`table tr:contains(${permission}) .tag:contains(${team}) .close-icon`).click();
        return this;
    }

    expectPermissionToExist(permission, team) {
        cy.get(`table tr:contains(${permission}) .tag:contains(${team})`).should('exist');
        return this;
    }

    expectPermissionNotToExist(permission, team) {
        cy.get(`table tr:contains(${permission}) .tag:contains(${team})`).should('not.exist');
        return this;
    }

    expectPermissionReadOnly(permission, team, readOnly) {
        if (readOnly) {
            cy.get(`table tr:contains(${permission}) .tag-label:contains(${team})`).should('exist');
        } else {
            cy.get(`table tr:contains(${permission}) .tag-label:contains(${team}) + .tag-close`).should('exist');
        }
        return this;
    }

    expectTeamsToExist(teams) {
        teams.forEach(team => cy.get(`table:first tr:contains(${team})`).should('exist'));
        return this;
    }

    expectTeamsNotToExist(teams) {
        teams.forEach(team => cy.get(`table:first tr:contains(${team})`).should('not.exist'));
        return this;
    }

    expectTeamsReadOnly(teams, readOnly) {
        if (readOnly) {
            teams.forEach(team => cy.get(`table:first .tag-label:contains(${team})`).should('not.exist'));
        } else {
            teams.forEach(team => cy.get(`table:first .tag-label:contains(${team}) + .tag-close`).should('not.exist'));
        }
        return this;
    }

    expectInheritTeamsDisabled() {
        cy.get('.inherit-checkbox input').should('exist').and('be.visible').and('be.disabled');
        return this;
    }

    expectInheritMessagePresent(folder) {
        cy.get(`p.inherit-checkbox`).contains(`Inherit teams and permissions from parent folder`).should('be.visible');
        cy.get(`p.inherit-checkbox a`).contains(`${folder}`);
        return this;
    }

    newTeam(teamName) {
        cy.get('#permissions #teams-permissions-table button.primary').click();
        cy.get('.xl-react-modal-content input').type(teamName);
        cy.get('.xl-react-modal-content button.primary').click();
    }

    removeTeam(team) {
        cy.get(`#teams-permissions-table table tr:contains(${team}) .action-label`).click();
        cy.get('.modal-footer button.primary').click();
        return this;
    }

    reset() {
        cy.get('header button:contains("Reset")').click();
        return this;
    }

}
