import FolderDetailsPage from '../pages/folder-details-page';

export default class FolderExplorerPage {

    static goToExplorer() {
        cy.visit("#/folders");
        return this;
    }

    static openFolder(folderName) {
        cy.get(`.folder-row-wrapper:contains(${folderName})`).scrollIntoView().should('be.visible');
        // We are clicking/opening folder by clicking anywhere inside of wrapped list item
        // which now has a button role (instead of a span with folder name, as was previously)
        cy.get(`.folder-row-wrapper:contains(${folderName}) li[role=button]`).click();
        return new FolderDetailsPage();
    }

    static expandEast() {
        Browser.waitForDisplayed('.toggler.toggler-collapse');
        cy.get(".toggler.toggler-collapse").click();
        return this;
    }

    static openCreateNewFolderModalAndInput(folderName) {
        cy.get('button.create-new-folder').click();
        cy.get(".xl-react-modal-content input").type(folderName);
        return this;
    }

    static createNewFolder(folderId) {
        cy.wait(1500);
        this.openCreateNewFolderModalAndInput(folderId);
        cy.get('.xl-react-modal-content .button.primary').click();
        cy.wait(1500);
        return this;
    }

    static expectContainsFolderRow(folderName, condition) {
        cy.get(`.folder-row-wrapper:contains(${folderName})`).should('have.length', condition ? 1 : 0);
        return this;
    }

    static searchFolder(folderName) {
        cy.get('.folder-list .search-filter').type(folderName);
        return this;
    }

    static deleteFolder() {
        cy.get('.dropdown-menu li:contains("Delete")').click();
        cy.get('.modal-dialog .button.primary').click();
        return this;
    }

    static expectPopupContainsCorrectItems() {
        let items = ['Add folder', 'Rename folder', 'Delete folder'];
        for (let item of items) {
            cy.get(`.ant-popover a:contains(${item})`).should('be.visible');
        }
        return this;
    }

    static showFolderOptions(folderName) {
        cy
            .get(`.folder-row-wrapper:contains(${folderName}) .folder-options-wrapper`)
            .invoke('show')
            .click();
    }

    static openCreateNewFolderModalFromPopupAndInput(folderName) {
        cy.get(`.ant-popover`).not('.ant-popover-hidden').get(`a:contains(Add folder)`).click();
        cy.get(".xl-react-modal-content input").type(folderName);
        return this;
    }

    static toggleFolder(folderName) {
        cy.get(`.folder-row-wrapper:contains(${folderName}) .rstm-toggle-icon`).click();
        return this;
    }

    static createNewFolderFromPopup(folderName, subFolderName) {
        this.showFolderOptions(folderName);
        this.openCreateNewFolderModalFromPopupAndInput(subFolderName);
        cy.get('.xl-react-modal-content .button.primary').click();
        return this;
    }

    static renameFolderFromPopup(folderToRename, folderName) {
        this.showFolderOptions(folderToRename);
        cy.get(`.ant-popover`).not('.ant-popover-hidden').get(`a:contains(Rename folder)`).click();
        cy.get(`.folder-row-wrapper input`).clear().type(folderName).type('{enter}');
        return this;
    }

    static deleteFolderFromPopup(folderTitle) {
        this.showFolderOptions(folderTitle);
        cy.get(`.ant-popover`).not('.ant-popover-hidden').get(`a:contains(Delete folder)`).click();
        cy.get(".xl-react-modal-content button.primary").click();
        return this;
    }

    static expectAddFolderButtonEnabled(enabled = true) {
        cy.get('button.create-new-folder').should(`${enabled ? 'not.' : ''}have.attr`, 'disabled');
        return this;
    }

    static expectFolderRenameErrorDialogShown() {
        cy.get(`.xl-react-modal-content .confirmation-content:contains(Folder name is already in use. Please choose another name.)`).should('be.visible');
    }

    static expectValidationErrorShown(text) {
        cy.get(`.xl-react-modal-content .error:contains(${text})`).should('be.visible');
    }
}
