import {InlineEditor} from "../pages/inline-editor";

export default class SystemMessageConfiguration {

    constructor() {
        this.FORM_CLASS_ID = '#system-message-modal';
    }

    enableSystemMessage() {
        cy.get(`${this.FORM_CLASS_ID} [name="enabled"]`)
            .check().should('be.checked');
        return this;
    }

    disableSystemMessage() {
        cy.get(`${this.FORM_CLASS_ID} [name="enabled"]`)
            .uncheck().should('not.be.checked');
        cy.get('.rte-overlay').should('have.length',1);
        return this;
    }

    enableAutomaticallySystemMessage() {
        cy.get(`${this.FORM_CLASS_ID} [name="automated"]`)
            .check().should('be.checked');
        return this;
    }

    disableAutomaticallySystemMessage() {
        cy.get(`${this.FORM_CLASS_ID} [name="automated"]`)
            .uncheck().should('not.be.checked');
        return this;
    }

    save() {
        cy.get(`${this.FORM_CLASS_ID} button[type="submit"]`).should('be.visible');
        cy.get(`${this.FORM_CLASS_ID} button[type="submit"]`).click();
        cy.get('#enabled').should('not.be.visible');
        cy.get('button.save.primary').should('not.be.visible');
        cy.wait(500); // wait some time since it takes a while sometimes to set the system message.
        return this;
    }

    setSystemMessage(message) {
        const path =`${this.FORM_CLASS_ID} [name="message"]`;
        cy.get(`${path}`).click({force: true});
        cy.get(`${path} .notranslate.public-DraftEditor-content`).type(message, {force: true});
        return this;
    }
}
