export default class ReleaseGroupsTimelinePage {
    constructor() {
        cy.get('.gantt-header-row').should('be.visible');
    }

    openContextMenu(releaseTitle) {
        cy.get(`.timeline-row-name:contains('${releaseTitle}') .options-icon`).click();
        return this;
    }

    openAddReleaseList() {
        cy.get('.new-group').click();
        return this;
    }

    filterReleases(text) {
        cy.get('.modal-filter').type(text);
        return this;
    }

    selectAllReleaseCheckbox() {
        cy.get(`#selectAllCheckbox`).click();
        return this;
    }

    addReleasesToGroup() {
        cy.get('.modal-footer .button.button.primary').click();
        return this;
    }

    expectNumberOfReleases(size) {
        cy.get('.timeline-row-name-release').should('have.length', size);
        return this;
    }

    expectNumberOfReleasesOnModal(size) {
        cy.get('.release-modal-line').should('have.length', size);
        return this;
    }
    
    removeFromGroup() {
        cy.get(`.ng-binding:contains('Remove from group')`).click();
        cy.get('.modal-footer .button.button.primary').click();
        return this;
    }

    expectPhaseDisplayed(phaseTitle) {
        cy.get(`.gantt-task-content:contains('${phaseTitle}')`, {timeout: 10000}).should('have.length', 1);
        return this;
    }

    expectReleaseDisplayed(releaseTitle) {
        cy.get(`.release-title:contains('${releaseTitle}')`, {timeout: 10000}).should('have.length', 1);
        return this;
    }

    expectReleaseNotDisplayed(releaseTitle) {
        cy.get(`.release-title:contains('${releaseTitle}')`, {timeout: 10000}).should('have.length', 0);
        return this;
    }

    expectReleaseGroupTitleDisplayed(releaseGroupTitle) {
        cy.get(`.group-title:contains('${releaseGroupTitle}')`).should('have.length', 1);
        return this;
    }

}
