export default class TaskGenerator {
    constructor(usingElement) {
        this.usingElement = usingElement;
    }

    addTask(taskName, taskGroup, taskType) {
        cy.get(`${this.usingElement}`).then(el => {
            if (!el.find('.quick-title:visible').length) {
                cy.get(`${this.usingElement} .add-task`).click();
            }
            cy.get(`${this.usingElement}`).find('.quick-title').type(taskName);
            cy.get(`${this.usingElement} .xlr-ctx-menu-toggle`).click();
            cy.get(`li.xlr-ctx-menu-item[data-test='${taskGroup}']:visible`).trigger('mouseover');
            cy.get(`li.xlr-ctx-menu-item[data-test='${taskType}']`).scrollIntoView().click();
            return cy.get(`${this.usingElement} a:contains("Add"):visible`).click();
        });
    }

    addManualTask(taskName) {
        return this.addTask(taskName, 'Core', 'xlrelease.Task');
    }

    addNotificationTask(taskName) {
        return this.addTask(taskName, 'Core', 'xlrelease.NotificationTask');
    }

    addScriptTask(taskName) {
        return this.addTask(taskName, 'Script', 'xlrelease.ScriptTask');
    }

    addGateTask(taskName) {
        return this.addTask(taskName, 'Core', 'xlrelease.GateTask');
    }

    addParallelGroup(taskName) {
        return this.addTask(taskName, 'Core', 'xlrelease.ParallelGroup');
    }
}
