export default class Dependency {
    constructor(path) {
        this.path = path;
    }

    edit() {
        cy.get(`${this.path} .link.context-menu-button`).click();
        cy.get(`${this.path} .popover .dropdown-menu #editDependency`).click();
        return this;
    }

    save() {
        cy.get(`${this.path} .save`).click();
        return this;
    }

    cancel() {
        cy.get(`${this.path} .cancel`).click();
        return this;
    }

    setRelease(releaseName) {
        this._setAutocompleteField('release', releaseName);
        return this;
    }

    setTask(title) {
        this._setAutocompleteField('task', title);
        return this;
    }

    expectReleaseToBe(releaseName) {
        cy.get(`${this.path} input[name="release"]`).should('have.value', releaseName);
        return this;
    }

    expectPhaseToBe(phaseName) {
        cy.get(`${this.path} input[name="phase"]`).should('have.value', phaseName);
        return this;
    }

    expectTaskToBe(taskName) {
        cy.get(`${this.path} input[name="task"]`).should('have.value', taskName);
        return this;
    }

    expectReadOnly() {
        cy.get(`${this.path} select:enabled`).should('have.length', 0);
        return this;
    }

    expectSaveButtonDisabled() {
        cy.get(`${this.path} button.save`).should('be.disabled');
        return this;
    }

    expectSaveButtonEnabled() {
        cy.get(`${this.path} button.save`).should('not.be.disabled');
        return this;
    }

    expectRemovable(expected = true) {
        cy.get(`${this.path} .link.context-menu-button`).click();
        cy.get(`${this.path} .popover .dropdown-menu #removeDependency`).should('have.length', expected ? 1 : 0);
        return this;
    }

    expectContextMenu(expected = true) {
        cy.get(`${this.path} .link.context-menu-button`).should('have.length', expected ? 1 : 0);
        return this;
    }

    remove() {
        cy.get(`${this.path} .link.context-menu-button`).click();
        cy.get(`${this.path} .popover .dropdown-menu #removeDependency`).click();
        return this;
    }

    exceptDependencyStatus(excepted) {
        cy.get(`${this.path} status-badge .label`).should('have.length', excepted ? 1 : 0);
        return this;
    }

    expectResolved() {
        cy.get(`${this.path} .line .check-icon`).should('have.length', 1);
        return this;
    }

    expectUnresolved() {
        cy.get(`${this.path} .line .check-icon`).should('have.length', 0);
        return this;
    }

    _setAutocompleteField(field, value) {
        cy.doWithRetry(
            () => cy.get(`${this.path} #${field}-dependency input`).click(),
            `ul.ui-autocomplete.xl-components.xl-widget-autocomplete:visible div.ui-menu-item-wrapper:visible:contains('${value}'), ul.ui-autocomplete.xl-components.xl-widget-autocomplete:visible div.ui-menu-item-wrapper:visible:contains('${value.replace(/ /g, '\u00a0')}')`);
        // seems that Cypress is flaky on visibility, this way we can
        // understand whether it can't find element or thinks that
        // it is not visible
        cy.get(`ul.xl-components.xl-widget-autocomplete li:contains('${value}'), ul.xl-components.xl-widget-autocomplete li:contains('${value.replace(/ /g, '\u00a0')}')`).first().should('exist');
        cy.get(`ul.xl-components.xl-widget-autocomplete li:contains('${value}'), ul.xl-components.xl-widget-autocomplete li:contains('${value.replace(/ /g, '\u00a0')}')`).first().should('be.visible');
        cy.get(`ul.xl-components.xl-widget-autocomplete li:contains('${value}'), ul.xl-components.xl-widget-autocomplete li:contains('${value.replace(/ /g, '\u00a0')}')`).first().trigger('mouseover').click();
        return this;
    }
}
