import UsersPage from './users-page';
import Page from './page';
import ReleasesListPage from "./releases-list-page";

export default class AngularPage {
    static go(url) {
        cy.visit(url);
        cy.reload();
    }

    static openUsers() {
        this.go('#/users');
        return new UsersPage();
    }

    static openReleasesList(filter) {
        const url = Page.appendFilterQueryString('/releases', filter);
        this.go(url);
        return new ReleasesListPage();
    }

    static stateReload() {
        cy.stateReload();
    }
}
