import {TaskDetails} from './task-details';
import {InlineEditor, PasswordInlineEditor, TextareaInlineEditor} from '../../pages/inline-editor';
import TagEditor from '../tag-editor';

export class NotificationDetails extends TaskDetails {

    constructor() {
        super();
        this.toEditor = new TagEditor('#resizable-modal .email-to');
        this.ccEditor = new TagEditor('#resizable-modal .email-cc');
        this.bccEditor = new TagEditor('#resizable-modal .email-bcc');
        this.replyToEditor = new InlineEditor('#resizable-modal .email-reply-to');
        this.fromEditor = new InlineEditor('#resizable-modal .email-from');
        this.senderUsernameEditor = new InlineEditor('#resizable-modal .email-senderUsername');
        this.senderPasswordEditor = new PasswordInlineEditor('#resizable-modal .email-senderPassword');
        this.subjectEditor = new InlineEditor('#resizable-modal .email-subject');
        this.bodyEditor = new TextareaInlineEditor('#resizable-modal .email-body');
        this.mailPrioritySelect = () => cy.get('#resizable-modal select.email-priority');
    }

    _addTags(values, editor) {
        values.forEach(value => editor.addTag(value));
    }

    _expectTags(values, editor) {
        values.forEach(value => editor.expectTaggedWith(value));
    }

    expectTo(...values) {
        this._expectTags(values, this.toEditor);
        return this;
    }

    setTo(...values) {
        this._addTags(values, this.toEditor);
    }

    expectCc(...values) {
        this._expectTags(values, this.ccEditor);
        return this;
    }

    setCc(...values) {
        this._addTags(values, this.ccEditor);
    }

    expectBcc(...values) {
        this._expectTags(values, this.bccEditor);
        return this;
    }

    setBcc(...values) {
        this._addTags(values, this.bccEditor);
    }

    getSubject() {
        return this.subjectEditor.value();
    }

    setSubject(value) {
        return this.subjectEditor.set(value);
    }

    getBody() {
        return this.bodyEditor.value();
    }

    setBody(value) {
        return this.bodyEditor.set(value);
    }

    getReplyTo() {
        return this.replyToEditor.value();
    }

    setReplyTo(value) {
        return this.replyToEditor.set(value);
    }

    getFrom() {
        return this.fromEditor.value();
    }

    setFrom(value) {
        return this.fromEditor.set(value);
    }

    getSenderUsername() {
        return this.senderUsernameEditor.value();
    }

    setSenderUsername(value) {
        return this.senderUsernameEditor.set(value);
    }

    getSenderPassword() {
        return this.senderPasswordEditor.value();
    }

    setSenderPassword(value) {
        return this.senderPasswordEditor.set(value);
    }

    setMailPriority(value) {
        this.mailPrioritySelect().focus().select(value).blur();
    }

    getMailPriority() {
        return this.mailPrioritySelect();
    }

    expectSubjectToBe(subject) {
        cy.get('#resizable-modal .email-subject').should('be', subject);
        return this;
    }

    expectBodyToBe(body) {
        cy.get('#resizable-modal .email-body').should('be', body);
        return this;
    }
}