import Page from './page';
import TagEditor from '../components/tag-editor';

export default class Teams {
    constructor() {
        cy.get('#teams-permissions-table').should('be.visible');
    }

    // refresh() {
    //     Page.softReload();
    //     return new Teams();
    // }

    expectTeamExists(teamName) {
        cy.get(`#teams-permissions-table .text-column:contains('${teamName}')`).should('have.length', 1);
        return this;
    }

    expectTeamContains(teamName, ...members) {
        let teamEditor = new TagEditor(`tr:contains('${teamName}')`);
        for (let member of members) {
            teamEditor.expectTaggedWith(`${member}`);
        }
        return this;
    }
}
