import ColorPicker from '../components/color-picker';
import {InlineEditor} from './inline-editor';
import ReleaseTask from './release-task';
import TaskGenerator from './task-generator';

export default class ReleasePhase {
    constructor(phaseSelector) {
        this.phaseSelector = phaseSelector;
        this.phase = cy.get(this.phaseSelector);
    }

    getNumberOfTasks() {
        return cy.get(`${this.phaseSelector} .task`);
    }

    getCurrentTasks() {
        return cy.get(`${this.phaseSelector} .task.active`);
    }

    getFailedTasks() {
        return cy.get(`${this.phaseSelector} .task.failed`);
    }

    getFailingTasks() {
        return cy.get(`${this.phaseSelector} .task.failing`);
    }

    getHeader() {
        return cy.get(`${this.phaseSelector} .phase-header`);
    }

    getColorPicker() {
        return new ColorPicker(`${this.phaseSelector} .pick-color`);
    }

    getTaskGenerator() {
        return new TaskGenerator(this.phaseSelector);
    }

    setTitle(title) {
        let editor = new InlineEditor(`${this.phaseSelector} .phase-title`);
        return editor.set(title);
    }

    getTask(taskName) {
        return new ReleaseTask(`${this.phaseSelector} .task:contains('${taskName}')`);
    }

    expandTaskGroup(taskGroupName) {
        cy.get(`${this.phaseSelector} .task-title:contains(${taskGroupName})`)
            .closest('.task-container')
            .find('.task-box .expander > i')
            .first()
            .then($icon => {
                if ($icon.hasClass('arrow-right-icon')) {
                    $icon.click();
                }
            });
        return this;
    }

    delete() {
        cy.get(`${this.phaseSelector} .delete-phase`).click();
        cy.get('.modal:visible .modal-header').should('contain', 'Delete Phase');
        return cy.get(".modal:visible .button:contains('Delete')").click();
    }

    duplicate() {
        return cy.get(`${this.phaseSelector} .duplicate-phase`).click();
    }

    expectContainingTask(taskName) {
        cy.get('.task-header').should('contain', taskName);
    }

    expectGateTasksCountToBe(count) {
        cy.get(`${this.phaseSelector} .task-box .task-type-gatetask:visible`).should('have.length', count);
    }

    expectParallelGroupsCountToBe(count) {
        cy.get(`${this.phaseSelector} .task-box .task-type-parallelgroup:visible`).should('have.length', count);
    }

    expectActionsDisabled() {
        cy.get(`${this.phaseSelector} .duplicate-phase`).should('have.length', 0);
        cy.get(`${this.phaseSelector} .delete-phase`).should('have.length', 0);
        cy.get(`${this.phaseSelector} .task .duplicate-task`).should('have.length', 0);
        cy.get(`${this.phaseSelector} .task .delete-task`).should('have.length', 0);
        cy.get(`${this.phaseSelector} .task-generator .add-task`).should('have.length', 0);
        cy.get(`${this.phaseSelector} .display`).should('have.length', 0);
    }

    expectDuplicateEnabled() {
        cy.get(`${this.phaseSelector} .duplicate-phase`).should('have.length', 1);
    }

    expectDeleteDisabled() {
        cy.get(`${this.phaseSelector} .delete-phase`).should('have.length', 0);
    }
}
