export default class FolderPermissionsPage {

    constructor() {
        cy.get('#permissions .table').should('be.visible');
    }

    removePermission(permission, team) {
        cy.get(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team}) .close-icon`).click();
        return this;
    }

    expectPermissionToExist(permission, team) {
        cy.get(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team})`).should('exist');
        return this;
    }

    expectPermissionNotToExist(permission, team) {
        cy.get(`.permissions-table-v2 tr.ng-scope:contains(${permission}) .tag:contains(${team})`).should('not.exist');
        return this;
    }

    expectTeamsToExist(teams) {
        teams.forEach(team => cy.get(`.permissions-table-v2:first tr.ng-scope:contains(${team})`).should('exist'));
        return this;
    }

    expectTeamsNotToExist(teams) {
        teams.forEach(team => cy.get(`.permissions-table-v2:first tr.ng-scope:contains(${team})`).should('not.exist'));
        return this;
    }

    expectInheritTeamsDisabled() {
        cy.get('.inherit-checkbox input').should('exist').and('be.visible').and('be.disabled');
        return this;
    }

    expectInheritMessagePresent(folder) {
        cy.get(`p.inherit-checkbox`).contains(`Inherit teams and permissions from parent folder`).should('be.visible');
        cy.get(`p.inherit-checkbox a`).contains(`${folder}`);
        return this;
    }

    newTeam(teamName) {
        cy.get('#permissions #teams-permissions-table button.primary').click();
        cy.get('add-team-modal #team-name').type(teamName);
        cy.get('add-team-modal button.primary').click();
    }

    removeTeam(team) {
        cy.get(`#teams-permissions-table .permissions-table tr:contains(${team}) .remove-action`).click();
        cy.get('.continue').click();
        return this;
    }

}
