import ReleasesListPage from './releases-list-page';

export default class FolderReleases {
    constructor() {
        cy.get('folder-release-list').should('have.length',1);
    }

    static open(folderId) {
        browser.setLocation(`/folders/${folderId}/releases`);
        return new FolderReleases();
    }

    static openReleasesFiltered(folderId, status) {
        cy.visit(`/#/folders/${folderId}/releases?has_filter&` + status);
        cy.get('div.alert.notice.releases-list-loaded:visible:contains("No releases found."), xlr-release-row:visible').should('exist');
        cy.waitUntilStable(
            2500,
            () => Cypress.$('div.alert.notice.releases-list-loaded:visible:contains("No releases found."), xlr-release-row:visible').length
        );

        return new FolderReleases();
    }

    expectReleasesStarted(...releases) {
        const list = new ReleasesListPage();
        for (const release of releases) {
            list.expectReleaseStarted(release);
        }
        return this;
    }

    expectReleasesPlanned(...releases) {
        const list = new ReleasesListPage();
        return releases.map((release) =>
            list.expectReleasePlanned(release));
    }

    expectReleasesArchived(...releases) {
        const list = new ReleasesListPage();
        for (const release of releases) {
            list.expectReleaseArchived(release);
        }
        return this;
    }

    expectReleasesCompleted(...releases) {
        const list = new ReleasesListPage();
        for (const release of releases) {
            list.expectReleaseCompleted(release);
        }
        return this;
    }

    expectReleasesAborted(...releases) {
        const list = new ReleasesListPage();
        for (const release of releases) {
            list.expectReleasePlanned(release);
        }
        return this;
    }

    expectReleasesDisplayed(releases) {
        for (const title in releases) {
            const expected = releases[title];
            if (expected.displayed && expected.index >= 0) {
                cy.get(`.release:nth('${expected.index}') .release-title`).contains(title);
                // expect(element(By.$(`.release:nth('${expected.index}') .release-title`)).getText()).toContain(title);
            }
            if (expected.phaseTitle && expected.index >= 0) {
                cy.get(`.release:nth('${expected.index}') .phase-title`).contains(expected.phaseTitle);
                // expect(element(By.$(`.release:nth('${expected.index}') .phase-title`)).getText()).toContain(expected.phaseTitle);
            }
        }
        return this;
    }

}
