export default class DateTimePicker {
    constructor(element) {
        this.element = element;
    }

    setDate({day, month, year}) {
        this.openDatePicker();
        if (year) {
            this.switchToMonth();
            this.switchToYear();
            cy.get(`.datepicker .year:contains('${year}')`).click();
        }
        if (month) {
            if (!year) {
                this.switchToMonth();
            }
            cy.get(`.datepicker .month:eq(${month - 1})`).click();
        }
        cy.get(`.datepicker .day:not(.old):not(.new):contains('${day}')`).first().click();
        // return element.all(By.$(`.datepicker .day:not(.old):not(.new):contains('${day}')`)).first().click();
    }

    setTime({hour, minute}, closeFn) {
        let isAmPmVisible;
        cy.get(`${this.element} .time-picker-holder`).children('input').then((el) => {
            isAmPmVisible = Cypress.$(el).attr('value');
            cy.get(`${this.element} .time`).click();

            if (isAmPmVisible.includes('AM') || isAmPmVisible.includes('PM')) {
                let meridianInput = cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-meridian");
                let meridian;
                if (hour > 12) {
                    meridian = 'PM';
                    hour = hour - 12;
                } else if (hour === 12) {
                    meridian = 'PM';
                } else if (hour === 0) {
                    hour = 12;
                    meridian = 'AM';
                } else {
                    meridian = 'AM';
                }
                meridianInput.click();
                meridianInput.clear();
                meridianInput.type(meridian);
            }
            if (hour !== null) {
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-hour").click();
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-hour").clear();
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-hour").type(hour);
            }
            if (minute !== null) {
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-minute").click();
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-minute").clear();
                cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-minute").type(minute);
            }
            return closeFn ? closeFn() : cy.get(".bootstrap-timepicker-widget .bootstrap-timepicker-hour").type('{esc}');
        });
    }

    openDatePicker() {
        cy.get(`${this.element} .date`).should('be.visible');
        cy.get(`${this.element} .date`).click();
        // return element(By.$(`${this.selector} .date`)).click();
    }

    switchToMonth() {
        cy.get(".datepicker-days .datepicker-switch").should('be.visible');
        cy.get(".datepicker-days .datepicker-switch").click();
        // return element(By.css(".datepicker-days .datepicker-switch")).click();
    }

    switchToYear() {
        cy.get(".datepicker-months .datepicker-switch").should('be.visible');
        cy.get(".datepicker-months .datepicker-switch").click();
        // return element(By.css(".datepicker-months .datepicker-switch")).click();
    }

    setDay(day) {
        cy.get(`${this.element} .date`).click();
        return cy.get(`.datepicker:visible td.day:contains('${day}')`).click();
    }

    addOneHourToDate() {
        cy.get(`${this.element} .time`).click();
        cy.get(".bootstrap-timepicker-widget [data-action='incrementHour']").click();
        return cy.get('.assignee .display').click({multiple: true, force: true});
    }

    removeDate() {
        cy.get(`${this.element} .remove-date`).click();
        return this;
    }

    expectDateToContain(text) {
        cy.get(`${this.element} .date`).should('contain', text);
    }

    expectTimeToContain(hours, minutes) {
        const timeFormat = {
            hour: "numeric",
            minute: "numeric"
        };

        cy.compareToLocalTime(`${hours}:${minutes}`, `.due-date .time-picker-holder`, timeFormat);
    }

    expectScheduledTimeToContain(hours, minutes) {
        const timeFormat = {
            hour: "numeric",
            minute: "numeric"
        };

        cy.compareToLocalTime(`${hours}:${minutes}`, `.scheduled-start-date .time-picker-holder`, timeFormat);
    }

    expectVisible(visible) {
        cy.get(`${this.element}`).should(`have.length`, visible ? 1 : 0);
    }

    expectDateToBeInferred() {
        cy.get(`${this.element} input.placeholder`).should('have.length', 1);
        return this;
    }

    expectDateToBe({day, month, year}, format) {
        cy.log(format);
        cy.compareToLocalDate(`${day}-${month}-${year}`, `${this.element} .date input`, format);
    }

    expectTimeToBe({hour, minute}, format) {
        cy.log(format);
        cy.compareToLocalTime(`${hour}:${minute}`, `${this.element} .time input`, format);
    }

    expectDateTimeToBe(dateTime, format) {
        this.expectDateToBe(dateTime, {day: format.day, month: format.month, year: format.year});
        this.expectTimeToBe(dateTime, {hour: format.hour, minute: format.minute});
    }
}
