import DateTimePicker from '../components/date-time-picker';
import {AutoCompleteInlineEditor, UserInlineEditor} from './inline-editor';

export default class ReleaseGridPage {
    constructor() {
        cy.get('.ui-grid-contents-wrapper').should('be.visible');
    }

    setHeaderFilter(columnTitle, valueToFilter) {
        const filter = cy.get(`.ui-grid-header-cell:contains(${columnTitle}) input`);
        filter.clear();
        filter.type(valueToFilter);
        return this;
    }

    setDateHeaderFilter(columnTitle, valueToFilter) {
        new DateTimePicker(`.ui-grid-header-cell:contains(${columnTitle}) .date-editor`).setDate(valueToFilter);
        return this;
    }

    expectRowCountToBe(cellCount) {
        cy.get('.ui-grid-canvas .name-cell').should('have.length', cellCount);
        return this;
    }

    expectExpandedRowCountToBe(rowCount) {
        cy.get(".ui-grid-canvas .arrow-down-icon").should('have.length', rowCount);
        return this;
    }

    collapseNthRowByItem(rowIndex) {
        // cy.get(".ui-grid-canvas .ui-grid-row .expand-icon").should("be.visible");
        // Browser.waitFor(".ui-grid-canvas .ui-grid-row .expand-icon");
        //Selector is really ugly, but couldn't find a better way to do this
        cy.get(`.ui-grid-canvas div[ng-click='grid.appScope.ctrl.gridApi.treeBase.toggleRowTreeState(row)']:eq(${rowIndex})`).click({force: true});
        // element(By.$(`.ui-grid-canvas div[ng-click='grid.appScope.ctrl.gridApi.treeBase.toggleRowTreeState(row)']:eq(${rowIndex})`)).click();
        return this;
    }

    expectItemWithTitleStatusAndDates(title, status, startDate, endDate) {
        cy.get(`.ui-grid-canvas .ui-grid-row:contains(${title}):contains(${status}):contains(${startDate}):contains(${endDate})`).should('be.visible');
        return this;
    }

    openItemDetails(itemTitle, detailsCallback) {
        // cy.wait(`.ui-grid-canvas .name-cell-title:contains(${itemTitle})`);
        cy.get(`.ui-grid-canvas .name-cell-title:contains(${itemTitle})`).click();
        return detailsCallback();
    }

    openContextMenu(task) {
        cy.waitUntilStable(500, () => Cypress.$(`.ui-grid-cell-contents`).length);
        cy.doWithRetry(
            () => cy.get(`.ui-grid-cell-contents:contains("${task}") .context-menu-button`).click({force: true}),
            '.popover .popover-content ul:visible'
        );
        cy.get('.popover .popover-content ul').should('be.visible');
        return this;
    }

    callMenuItemForTask(item, task) {
        this.openContextMenu(task);
        return cy.get(`#context-menu-container a:contains('${item}')`).click({force: true});
    }

    expectDisabledContextMenuItem(item) {
        cy.get(`#context-menu-container li:contains('${item}')`).should('have.class', 'disabled');
        return this;
    }

    expectEnabledContextMenuItem(item) {
        cy.get(`#context-menu-container li:contains('${item}')`).should('not.be.disabled');
        return this;
    }

    callSubMenuItemForTask(item, task, ...subitems) {
        const calledMenuItem = this.callMenuItemForTask(item, task);
        return subitems.reduce((acc, subitem) =>
                acc.then(() => { return cy.get(`li a:contains('${subitem}')`).click({force: true}); })
            , calledMenuItem);
    }

    hasTaskAssignedTo(task, user) {
        cy.get(`.ui-grid-row:contains('${task}') span:contains('${user}')`).should('be.visible');
        return this;
    }

    hasTaskStatus(task, status) {
        cy.get(`.ui-grid-row:contains('${task}') span:contains('${status}')`).should('be.visible');
        return this;
    }

    hasTaskIcon(task, icon) {
        cy.get(`.ui-grid-row:contains('${task}') .${icon}`).should('be.visible');
        return this;
    }

    expectOverdueOnEndDate(task) {
        cy.get(`.ui-grid-row:contains('${task}') i.xl-icon.delay-icon.overdue-icon`).should('be.visible');
        return this;
    }

    expectTaskRowCountToBe(task, cellCount) {
        cy.get(`.name-cell-title:contains(${task})`).should('have.length', cellCount);
        return this;
    }

    clickModalPrimaryButton() {
        return cy.get('.modal-content .primary').click();
    }

    setModalTextAndClick(text) {
        cy.get('.modal-body textarea').type(text);
        return this.clickModalPrimaryButton();
    }

    start() {
        cy.get('.start-release').click();
        cy.get(".modal:visible .button:contains('Start')").click();
        return this;
    }

    abort(abortComment = "Aborted in testing") {
        cy.get('.abort-release').click();
        cy.get('textarea[ng-model="abortComment"]').type(abortComment);
        cy.get('.modal:visible .continue').click();
        return this;
    }

    expectStatus(status) {
        cy.get(`#release.${status}`).should('be.visible');
        return this;
    }

    selectTask(task) {
        cy.get(`.ui-grid-cell-contents:contains(${task}) .item-selector`).click({force: true});
        return this;
    }

    selectSubtasks(item) {
        cy.get(`.ui-grid-cell-contents:contains(${item}) .tasks-group-select`).click({force: true});
        return this;
    }

    shiftSelectFromTo(taskFrom, taskTo) {
        cy.get(`.ui-grid-cell-contents:contains(${taskFrom}) .item-selector`).click({force: true});

        cy.get('body').type('{shift}', {release: false});
        cy.get(`.ui-grid-cell-contents:contains(${taskTo}) .item-selector`).click({force: true});
        cy.get('body').type('{shift}', {release: true});

        return this;
    }

    expectSelectedTasksCounter(text) {
        cy.get(`.actions-bar-counter`).should('be.visible');
        cy.get(`.actions-bar-counter`).should('contain', text);
        return this;
    }

    clearSelection() {
        cy.get('.actions-bar-clear').click();
        return this;
    }

    deleteSelectedTasks() {
        cy.get('.remove-action').click({force: true});
        return this;
    }

    clickOnMoreActions() {
        cy.get('.actions-bar-container .more-actions').click();
        return this;
    }

    clickCompleteAction() {
        cy.get('.actions-bar-container .complete-action').click();
        return this;
    }

    clickSkipAction() {
        cy.get('.actions-bar-container .skip-action').click({force: true});
        return this;
    }

    clickReopenAction() {
        cy.get('.actions-bar-container .reopen-action').click({force: true});
        return this;
    }

    clickFailAction() {
        cy.get('.actions-bar-container .fail-action').click();
        return this;
    }

    clickRetryAction() {
        cy.get('.actions-bar-container .retry-action').click();
        return this;
    }

    assignSelectedTasks(owner, team) {
        cy.get('.assign-action').click();
        const ownerSelector = new UserInlineEditor('.task-owner');
        ownerSelector.focus();
        ownerSelector.enter(owner);
        cy.get('.principal').click();
        const teamSelector = new AutoCompleteInlineEditor('.task-team');
        teamSelector.focus();
        teamSelector.select(team);
        return this;
    }

    insertCommentForAction(comment) {
        cy.get('.actions-modal-comment').click();
        cy.get('.actions-modal-comment').type(comment);
        return this;
    }

    commentSelectedTasks(comment) {
        cy.get('.add-comment-action').click();
        this.insertCommentForAction(comment);
        return this;
    }

    confirmAction() {
        cy.get('.modal-footer .primary').should('be.visible');
        cy.get('.modal-footer .primary').click();
        return this;
    }

    expectDisabledAction(action) {
        cy
            .get(`.actions-bar-container button:contains('${action}')`)
            .should('be.disabled');
        return this;
    }

    expectEnabledAction(action) {
        cy
            .get(`.actions-bar-container button:contains('${action}')`)
            .should('not.be.disabled');
        return this;
    }

    expectDisabledActionsOnMoreActionsMenu(actions) {
        this.clickOnMoreActions();
        const actionDisabled = (action) => {
            cy
                .get(`.actions-bar-container .popover a:contains('${action}')`)
                .should('have.class', 'link-disabled');
        };

        if (Cypress._.isArray(actions)) {
            actions.forEach(action => actionDisabled(action));
        } else {
            actionDisabled(actions);
        }
        return this;
    }
}

global.ReleaseGridPage = ReleaseGridPage;
