import Modal from '../components/modal';
import {XlrListStringWithVariables, XlrMapStringStringWithVariables} from "../components/xlr-input-with-variables";
import DateTimePicker from "../components/date-time-picker";

export default class FolderVariablesPage {
    constructor() {
        cy.get('.button.primary').should('contain',"New folder variable");
        return this;
    }

    openNewVariableModal() {
        cy.get('.button.primary:contains("New folder variable")').click();
        return new FolderVariableDetails();
    }

    openDeleteModal(variable) {
        cy.get(`.variable:contains('${variable}') .action.delete`).click();
        return this;
    }

    editReplaceModal(){
        cy.get('.editable').click();
        return this;
    }

    switchToggle() {
        cy.get('.variable-toggle button').click();
        return this;
    }

    edit(name) {
        cy.get(`.variable:contains('${name}') .action.edit`).click();
        return new FolderVariableDetails();
    }

    selectFor(currentVar, newVar) {
        cy.get(`.variable-editor #${currentVar} .ui-autocomplete-input`).focus();
        cy.get(`.ui-autocomplete li.ui-menu-item:contains(${newVar})`).click();
        return this;
    }

    setValue(newValue) {
        cy.get('input.editable').clear().type(newValue);
        return this;
    }

    replaceAndDelete() {
        cy.get('button.delete').click();
    }

    expectVariablesDisplayed(variables) {
        for (const name in variables) {
            const expected = variables[name];
            cy.get(`.variable:contains('${name}')`).should(`${expected ? '' : 'not.'}visible`);
        }
        return this;
    }

    expectContainingVariable(name, value) {
        cy.get(`.variable:contains('${name}')`).should('have.length', 1);
        cy.get(`.variable:contains('${name}'):contains('${value}')`).should('have.length', 1);
        return this;
    }

    expectCountOfVariables(count) {
        cy.get('.variable').find('.data-row').should('have.length', count);
        return this;
    }

    expectNoVariables() {
        cy.get('.variables-list').contains('No variables defined.');
        return 0;
    }
}

class FolderVariableDetails extends Modal {

    expectVariablePrefix(prefix) {
        cy.get('.input-group-addon').should('contain', prefix);
        return this;
    }

    setName(name) {
        cy.get('.variable-name input').clear();
        cy.get('.variable-name input').type(name);
        return this;
    }

    selectType(type) {
        cy.get(`select`).select(type);
        return this;
    }

    setTextValue(value) {
        cy.get('#modal input[ng-model="var.value"]').click();
        cy.get('#modal input[ng-model="var.value"]').type(value);
        return this;
    }

    setMulitineTextValue(value) {
        cy.get('#modal textarea[ng-model="var.value"]').clear();
        cy.get('#modal textarea[ng-model="var.value"]').type(value);
        return this;
    }

    clearTextValue(){
        cy.get('#modal input[ng-model="var.value"]').clear();
        return this;
    }

    clickMultiline() {
        cy.get('#modal #multiline').click();
        return this;
    }

    addPossibleValue(value) {
        cy.get('.xl-components-input-full input[ng-model="ngModel"]').clear();
        cy.get('.xl-components-input-full input[ng-model="ngModel"]').type(value);
        cy.get('.xl-components-input-full .xl-btn-add').click();
        return this;
    }

    choosePossibleValuesVariable(name) {
        this._possibleValues()
            .toggleMode()
            .variableSelector()
            .focus()
            .select(name);
        return this;
    }

    createPossibleValuesVariable(name) {
        this._possibleValues()
            .toggleMode()
            .variableSelector()
            .focus()
            .enter(name)
            .select(name);
        return this;
    }

    expectPossibleValuesVariable(name) {
        this._possibleValues()
            .expectVariableMode()
            .variableSelector()
            .expectValue(name);
        return this;
    }

    selectValue(value) {
        cy.get(`option:contains('${value}')`).click();
        return this;
    }

    clickCheckbox() {
        cy.get('#modal input[ng-model="var.value"]').click();
        return this;
    }

    setLabel(value) {
        cy.get('#modal input[ng-model="var.label"]').clear();
        cy.get('#modal input[ng-model="var.label"]').type(value);
        return this;
    }

    setDescription(value) {
        cy.get('#modal input[ng-model="var.description"]').clear();
        cy.get('#modal input[ng-model="var.description"]').type(value);
        return this;
    }

    save() {
        cy.get('#modal button.save').scrollIntoView().click();
        cy.get('#modal').should('not.be.visible');
        return new FolderVariablesPage();
    }

    cancel() {
        cy.get("button.cancel").click();
        return this;
    }

    close() {
        return cy.get('.close').click();
    }

    expectSaveButtonInvisible() {
        cy.get("button.save:visible").should('have.length', 0);
        return this;
    }

    expectSaveButtonDisabled() {
        cy.get("button.save:disabled").should('have.length', 1);
        return this;
    }

    expectSaveButtonEnabled() {
        cy.get("button.save:enabled").should('have.length', 1);
        return this;
    }

    expectLabel(label) {
        cy.get(`.control-label:contains('${label}')`).should('have.length', 1);
        return this;
    }

    expectNotToBeEditable(value) {
        cy.get(`.variable-name span:contains('${value}')`).should('have.length', 1);
        return this;
    }

    expectName(value) {
        cy.get(`.variable-name:contains('${value}')`).should('have.length', 1);
        return this;
    }

    expectNameInput(value) {
        cy.get("#modal var.key").should('have.value', value);
        return this;
    }

    expectValueToBe(value) {
        cy.get(".variable-value").invoke('text'),then(text => {
                if (text) {
                    expect(text).to.have.string(value);
                } else {
                    cy.get('#modal input[ng-model="var.value"]').should('have.value', value);
                }
            }
        );
        return this;
    }

    expectTextareaValueToBe(value) {
        cy.get('#modal textarea[ng-model="var.value"]').should('have.value', value);
        return this;
    }

    expectLabelAndDescription(label, desc) {
        cy.get('#modal var.label').should('have.value', label);
        cy.get('#modal var.description').should('have.value', desc);
        return this;
    }

    expectNoValidationErrors() {
        cy.get(".field-errors span:visible").should('have.length', 0);
        return this;
    }

    expectValidationError(text) {
        cy.get(`.field-errors span:visible:contains('${text}')`).should('have.length', 1);
        return this;
    }

    expectPossibleValues(values) {
        this._possibleValues()
            .editor()
            .shouldHaveItems(values);
        return this;
    }

    setDate(date) {
        const dateTimePicker = new DateTimePicker(`#modal .date-editor:first`);
        dateTimePicker.setDate(date);
        return this;
    }

    _possibleValues() {
        return new XlrListStringWithVariables('#modal div[name=expanded-value-provider-value]');
    }

    _possibleMapValues() {
        return new XlrMapStringStringWithVariables('#modal .xl-map-string-string');
    }
}
