import AddTemplateDropdown from './add-template-dropdown';
import ReleasePage from "./release-page";

export default class FolderTemplatesListPage {

    constructor() {
        cy.get('#templates').should('be.visible');
    }

    addTemplate() {
        return new AddTemplateDropdown('#list-add-template');
    }

    expectTemplatesCountToBe(count) {
        cy.get(".raised-link").should('have.length', count);
        return this;
    }

    createNewTemplate() {
        cy.get(".new-template").click();
        return new TemplatePropertiesPage();
    }

    openTemplateByName(templateName) {
        cy.get(`.template:contains('${templateName}') .raised-link`).click();
        return new ReleasePage();
    }

    openImportTemplateDialog() {
        element(By.css(".import-template")).click();
        return new ImportTemplateDialog();
    }

    searchBy(criteria) {
        cy.get(".searchFilter").clear();
        cy.get(".searchFilter").type(criteria);
        cy.wait(500);
        return this;
    }

    expectTemplateVisible(title, expected = true) {
        cy.get(`.template:contains('${title}')`).should('have.length', expected ? 1 : 0);
        return this;
    }

    delete(title) {
        cy.get(`.template:contains('${title}') .delete`).click();
        cy.get('.modal .continue').click();
        return this;
    }
}
