import FolderDetailsPage from '../pages/folder-details-page';

export default class FolderExplorerPage {

    static delete(folderTitle) {
        cy.get(`.ui-grid-row:contains(${folderTitle}) .link:contains('Delete')`).click();
        cy.get("button.primary").click();
        return this;
    }

    static goToExplorer() {
        cy.visit("#/folders");
        return this;
    }

    static goToFolder(folderId) {
        cy.server();
        cy.route('POST', /releases\/(templates\/)?search/).as('goToInFolder');
        cy.visit(`#/folders/Applications/${folderId}/templates`);
        cy.get('.ui-grid-row-selected');
        cy.wait('@goToInFolder');
        return this;
    }

    static openFolder(folderName) {
        cy.get(`.ui-grid-row-title:contains(${folderName})`).click();
        cy.get(`.ui-grid-row:contains(${folderName})`).should('have.class', 'ui-grid-row-selected');
        return new FolderDetailsPage();
    }

    static selectFolder(folderName) {
        cy.get(`.ui-grid-row-title:contains(${folderName})`).click();
        return this;
    }

    static expandSelected() {
        cy.get('.ui-grid-row-selected .toggle-icon').click();
        return this;
    }

    static expandWest() {
        cy.get('.toggler.toggler-expand').first().click();
        return this;
    }

    static expandEast() {
        Browser.waitForDisplayed('.toggler.toggler-collapse');
        cy.get(".toggler.toggler-collapse").click();
        return this;
    }

    static expectRowContainsActions(condition) {
        cy.get('.ui-grid-row-selected .action:contains("Delete")').should('have.length', condition ? 1 : 0);
        return this;
    }

    static expectRowIsSelected(condition) {
        cy.get('.ui-grid-row-selected').should('have.length', condition ? 1 : 0);
        return this;
    }

    static openCreateNewFolderModalAndInput(folderName) {
        cy.get('.folder-list span.create-new-folder').click();
        cy.get("[name='createFolderForm'] #folder-name").type(folderName);
        return this;
    }

    static createNewFolder(folderId) {
        cy.wait(1500);
        this.openCreateNewFolderModalAndInput(folderId);
        cy.get('.modal-dialog .button.continue').click();
        return this;
    }

    static expectContainsFolderRow(folderName, condition) {
        cy.get(`.ui-grid-row:contains(${folderName})`).should('have.length', condition ? 1 : 0);
        return this;
    }

    static searchFolder(folderName) {
        cy.get('.folder-list .search-filter').type(folderName);
        return this;
    }

    static deleteFolderFromFullView(folderName) {
        // Browser.waitForDisplayed(`.ui-grid-row:contains(${folderName}) .action:contains(Delete) .link`);
        cy.get(`.ui-grid-row:contains(${folderName}) .action:contains(Delete) .link`).click();
        // Browser.waitForDisplayed(".modal-dialog button.primary:contains(Delete)");
        cy.get(".modal-dialog button.primary:contains(Delete)").click();
        return this;
    }

    static showPopup() {
        cy.get(".ui-grid-row-selected .options-icon").click();
        return this;
    }

    static deleteFolder() {
        cy.get('.dropdown-menu li:contains("Delete")').click();
        cy.get('.modal-dialog .button.primary').click();
        return this;
    }

    static expectPopupContainsCorrectItems() {
        let items = ['Add folder', 'Rename', 'Delete'];
        for (let item of items) {
            cy.get(`xlr-context-menu a:contains(${item})`).should('be.visible');
        }
        return this;
    }

    static openCreateNewFolderModalFromPopupAndInput(folderName) {
        cy.get("xlr-context-menu a:contains(Add folder)").click();
        cy.get("[name='createFolderForm'] #folder-name").type(folderName);
        return this;
    }

    static createNewFolderFromPopup(folderId) {
        this.openCreateNewFolderModalFromPopupAndInput(folderId);
        cy.get(".modal-dialog .button.continue").click();
        return this;
    }

    static renameFolderFromPopup(folderName) {
        cy.get("xlr-context-menu a:contains(Rename)").click();
        cy.get(".folder-name-input").clear().type(folderName).type('{enter}');
        return this;
    }

    static deleteFolderFromPopup() {
        cy.get("xlr-context-menu a:contains(Delete)").click();
        cy.get(".modal-dialog button.primary").click();
        return this;
    }

    static renameFolderFromFullView(folderToRename, folderName) {
        // Browser.waitForDisplayed(`.ui-grid-row:contains(${folderToRename}) .action:contains(Rename) .link`);
        cy.get(`.ui-grid-row:contains(${folderToRename}) .action:contains(Rename) .link`).click();
        // browser.sleep(200);
        // Browser.waitForDisplayed(".folder-name-input");
        cy.get('.folder-name-input').clear();
        cy.get('.folder-name-input').type(folderName);
        cy.get('.folder-name-input').type('{enter}');
        return this;
    }

    static createNewFolderFromFullView(parentFolder, folderName) {
        // Browser.waitForDisplayed(`.ui-grid-row:contains(${parentFolder}) .action:contains(Add folder) .link`);
        cy.get(`.ui-grid-row:contains(${parentFolder}) .action:contains(Add folder) .link`).click();
        cy.get("[name='createFolderForm'] #folder-name").type(folderName);
        cy.get(".modal-dialog .button.continue").click();
        return this;
    }

    static expectAddFolderButtonEnabled(enabled = true) {
        cy.get('.folder-list span.create-new-folder').should(`${enabled ? 'not.' : ''}have.attr`, 'disabled');
        return this;
    }

    static expectFolderRenameErrorDialogShown(newName) {
        cy.get('.modal-title:contains(Rename Folder)').should('be.visible');
        cy.get(`.modal-body:contains(The name ${newName} is already in use. Please choose another name.)`).should('be.visible');
    }

    static expectValidationErrorShown(text) {
        cy.get(`.modal-body .field-errors span:contains(${text})`).should('be.visible');
    }
}
