import TemplatesListPage from './template-page';
import ReleasesListPage from './releases-list-page';
import ReleaseGanttPage from './release-gantt-page';
import {ReleasePropertiesPage} from './release-properties-page';
import CalendarPage from './calendar-page';
import ReleasePage from './release-page';
import ProfilePage from './profile-page';
import ConfigurationPage from './configuration-page';
import TasksListPage from './tasks-list-page';
import RolesPage from './roles-page';
import PermissionsPage from './permissions-page';
import ReleaseGroupsPage from './release-groups-page';
import UsersPage from './users-page';
import SmtpPage from './smtp-page';
import FolderDetailsPage from "./folder-details-page";
import GlobalVariablesPage from "./global-variables-page";
import FolderPermissionsPage from "./folders/folder-permissions-page";
import GeneralSettingsPage from "./general-settings-page";
import ReleaseVariablesPage from "./release-variables-page";
import TaskAccessPage from "./task-access-page";
import ReleaseValueStreamPage from "./release-value-stream-page";

export default class Page {
    static openDefault() {
        cy.visit('#/');
        return new ReleasesListPage();
    }

    static clickElseWhere() {
        cy.get(".main-header .current-user").click();
    }

    static openReleasesList(filter) {
        let url = this.appendFilterQueryString('#/releases', filter);
        cy.visit(url);
        return new ReleasesListPage();
    }

    static openReleasesListManually() {
        cy.get('#main-menu button:contains("Releases")').click();
        cy.get(`.nav-in-header li:contains('Releases')`).click();
        return new ReleasesListPage();
    }

    static openRelease(releaseId) {
        cy.visit(`#/releases/${releaseId}`);
        return new ReleasePage();
    }

    static openReleaseOnVariablesPage(releaseId) {
        cy.visit(`#/releases/${releaseId}/variables`);
        return new ReleaseVariablesPage();
    }

    static openTaskInRelease(releaseId, filter) {
        let url = this.appendFilterQueryString(`#/releases/${releaseId}`, filter);
        cy.visit(url);
        return new ReleasePage();
    }

    static openConfiguration() {
        cy.visit(`#/configuration`);
        return new ConfigurationPage();
    }

    static openReleaseLogs(releaseId, filter) {
        let url = this.appendFilterQueryString(`#/releases/${releaseId}/logs`, filter);
        cy.visit(url);
        return new Logs();
    }

    static openReleaseProperties(releaseId) {
        let url = this.appendFilterQueryString(`#/releases/${releaseId}/properties`);
        cy.visit(url);
        return new ReleasePropertiesPage();
    }

    static openReleaseValueStream(filter) {
        let url = '#/release-value-stream';
        if (filter) {
            url += `?has_filter&${filter}`;
        }
        cy.visit(url);
        return new ReleaseValueStreamPage();
    }

    static openGantt(releaseId) {
        cy.visit(`#/releases/${releaseId}/planner`);
        return new ReleaseGanttPage();
    }

    static openTemplate(templateId) {
        cy.visit(`#/templates/${templateId}`);
        return new ReleasePage();
    }

    static openTemplatesList(filter) {
        let url = "#/templates";
        if (filter) {
            url += `?has_filter&title=${filter}`;
        }
        cy.visit(url);
        return new TemplatesListPage();
    }

    static openTemplatesListManually() {
        cy.get('#main-menu button:contains("Design")').click();
        cy.get('.bread-crumbs ul li:contains("Templates")').click();
        return new TemplatesListPage();
    }

    static openTasksList(filter) {
        const url = this.appendFilterQueryString('#/tasks', filter);

        cy.visit(url);
        return new TasksListPage();
    }

    static openCalendar(filter) {
        const url = this.appendFilterQueryString('#/calendar', filter);

        cy.visit(url);
        return new CalendarPage();
    }

    static openRoles() {
        cy.visit('#/roles');
        return new RolesPage();
    }

    static openGlobalVariables() {
        cy.visit('#/global-variables');
        return new GlobalVariablesPage();
    }

    static openPermissions() {
        cy.visit('#/permissions');
        return new PermissionsPage();
    }

    static openSmtp() {
        cy.visit('#/smtp');
        return new SmtpPage();
    }

    static clearClientSettings() {
        return cy.get("#clear-client-settings").click({force: true});
    }

    static openDashboardReports() {
        cy.visit('#/reports');
        return new DashboardReportsPage();
    }

    static openProfile() {
        cy.visit('#/profile');
        return new ProfilePage();
    }

    static openUsers() {
        cy.visit('#/users');
        return new UsersPage();
    }

    static openTaskAccess() {
        cy.visit('#/task-access');
        return new TaskAccessPage();
    }

    static openReleaseGroups() {
        cy.visit('#/groups');
        return new ReleaseGroupsPage();
    }

    static openFolder(folderId) {
        cy.visit(`#/folders/${folderId}/templates?has_filter`);
        return new FolderDetailsPage();
    }

    static openPermissionsInFolder(folderId) {
        cy.visit(`#/folders/${folderId}/permissions`);
        return new FolderPermissionsPage();
    }

    static openGeneralSettings() {
        cy.server();
        cy.route('GET', '/settings/ci/Configuration/settings/ThemeSettings**').as('loadThemeSettings');
        cy.visit('#/general-settings');
        cy.wait('@loadThemeSettings');
        return new GeneralSettingsPage();
    }

    static waitRequestEnd() {
        expect(cy.get('#loading:hidden').then((size) => size.length)).toBe(1);
    }

    static appendFilterQueryString(url, filter) {
        if (filter) {
            let queryString = ((() => {
                let result = [];
                for (let key in filter) {
                    let value = filter[key];
                    if (value) {
                        if (value === true) {
                            result.push(`${key}`);
                        } else {
                            result.push(`${key}=${encodeURIComponent(value)}`);
                        }
                    }
                }

                return result;
            })()).join('&');
            if (queryString) {
                url += `?${queryString}`;
            }
        }

        return url;
    }

    static softReload() {
        return cy.reload();
    }
}
