import DateTimePicker from '../date-time-picker';
import {TaskDetails} from './task-details';
import {VariableListInlineEditor} from "../../pages/inline-editor";
import {XlDipListOfCi} from "../xl-components";
import _ from 'lodash';

export class UserInputDetails extends TaskDetails {

    complete() {
        cy.get('button').contains('Complete').click();
        cy.get('button').contains('OK').click();
        return this;
    }

    setDateVariable(inputId, value) {
        cy.server();
        cy.route('PUT', '/api/v1/releases/**').as('updateVariable');
        new DateTimePicker(`#${inputId} .date-editor`).setDate(value);
        cy.wait('@updateVariable');
        return this;
    }

    expectUserInputVariableValueToBe(value) {
        cy.get('.form-group .display').should('contain', value);
        return this;
    }

    expectCompletedUserInputVariableValueToBe(value) {
        cy.get('.form-group .read-only').should('contain', value);
        return this;
    }

    expectVariablesDisplayedUnderDropdown() {
        cy.get('.button:contains("Edit variable list")').click();
        cy.get('.xl-components-input').click();
        return this;
    }

    expectVariablesDisplayed(variables) {
        cy.get("form[name=userInputForm] .form-group").should('have.length', _.keys(variables).length);
        Object.entries(variables).forEach(([name, value]) => {
            cy.get(`.variable-editor:contains('${name}')`).should(`${value ? '' : 'not.'}visible`);
        });
        return this;
    }

    expectDesignModeEnabled(enabled) {
        if (enabled) {
            cy.get("button:contains('Edit variable list')").should('be.visible');
        } else {
            cy.get("button:contains('Edit variable list')").should('not.be.visible');
        }
        return this;
    }

    expectUserInputFormDisplayed() {
        cy.get(`form[name=userInputForm]`, {timeout: 6000}).should('be.visible');
        return this;
    }

    switchToDesignMode() {
        cy.get("button:contains('Edit variable list')").click();
        return this;
    }

    getVariablesPicker() {
        return new XlDipListOfCi("form[name=userInputDesignForm] div[xl-dip-list-of-ci]");
    }

    saveVariablesList() {
        cy.get("form[name=userInputDesignForm] .button.save").click();
        return this;
    }

    setVariableValue(key, value) {
        this.expectUserInputFormDisplayed();
        new VariableListInlineEditor(`form[name=userInputForm] div[inline-text-editor][name='${key}']`)
            .set(value);
        return this;
    }

}
