import {TaskDetails} from "./task-details";

export class ExternalScriptTaskDetails extends TaskDetails {
    expectInputPropertiesEditable() {
        [
            ['#url', 'input[type=text]'],
            ['#username', 'input[type=text]'],
            ['#password', 'input[type=password]'],
            ['#scriptEngine', 'select.editable:visible']
        ].forEach(field => {
            const [block, inputSelector] = field;
            cy.get(block + ' div.display').click();
            cy.get(block + ' ' + inputSelector).should('be.visible');
            cy.get(block + ' ' + inputSelector).should('not.have.attr', 'disabled');
            cy.get(block + ' ' + inputSelector).should('not.have.attr', 'readonly');
        });
    }
}
