import DateFilters from '../components/date-filters';
import {PhaseDetails} from './release-page';
import {TaskDetails} from "../components/task-details/task-details";

export default class ReleaseGanttPage {
    constructor() {
        cy.get('#gantt').should('be.visible');
    }

    getLeftPanel() {
        return new GanttLeftPanel();
    }

    expectItemDisplayed(itemTitle) {
        cy.get('#gantt .gantt_container .gantt_task_content').should('contain',itemTitle);
        // expect(element('#gantt .gantt_container .gantt_task_content').text()).toContain(itemTitle);
        return this;
    }

    expectItemNotDisplayed(itemTitle) {
        cy.get('#gantt .gantt_container .gantt_task_content').should('not.contain',itemTitle);
        // expect(element('#gantt .gantt_container .gantt_task_content').text()).not().toContain(itemTitle);
        return this;
    }

    expectReleaseDisplayed(releaseTitle) {
        cy.get('#gantt').should('contain',releaseTitle);
        cy.get('#gantt .gantt_container').should('have.length',1);
        // expect(element('#gantt').text()).toContain(releaseTitle);
        // expect(element('#gantt .gantt_container').count()).toBe(1);
        return this.expectItemDisplayed(releaseTitle);
    }

    expectPhaseDisplayed(phaseTitle) {
        return this.expectItemDisplayed(phaseTitle);
    }


    expectTaskDisplayed(taskTitle) {
        return this.expectItemDisplayed(taskTitle);
    }

    expectTaskNotDisplayed(taskTitle) {
        return this.expectItemNotDisplayed(taskTitle);
    }

    expectSameWidth(title1, title2) {
        cy.get(`.gantt_task_line:contains('${title1}')`).then($el1 => {
            cy.get(`.gantt_task_line:contains('${title2}')`).then($el2 => {
                expect($el1.width()).to.be.within($el2.width(),$el2.width()+3);
            });
        });
        // dimensions().expectSameWidth(`.gantt_task_line:contains('${title1}')`, `.gantt_task_line:contains('${title2}')`);
        return this;
    }

    expectDifferentWidth(title1, title2) {
        cy.get(`.gantt_task_line:contains('${title1}')`).then($el1 => {
            cy.get(`.gantt_task_line:contains('${title2}')`).then($el2 => {
                expect($el1.width()).to.not.eql($el2.width());
            });
        });
        // dimensions().expectDifferentWidth(`.gantt_task_line:contains('${title1}')`, `.gantt_task_line:contains('${title2}')`);
        return this;
    }

    expectElementWithClasses(title, ...classes) {
        cy.get(`.gantt_task_line:contains('${title}').${classes.join('.')}`).should('have.length',1);
        return this;
    }

    open(title) {
        cy.get(`.gantt_cell:contains('${title}') .gantt_open`).should('be.visible');
        cy.wait(500);
        cy.get(`.gantt_cell:contains('${title}') .gantt_open`).click({force: true});
        return this;
    }

    expectDisplayedInScale(text) {
        cy.get('#gantt .gantt_scale_line').should('contain',text);
        // expect(element('#gantt .gantt_scale_line').text()).toContain(text);
        return this;
    }

    expectDateDisplayedInScale(format, date) {

        DateFilters.expectGanttLeftPanelDateFilters({from: date},format);
        // dates().expectContainingDate('#gantt .gantt_scale_line', format, date);
        return this;
    }

    selectBiggerZoom() {
        cy.get("#gantt #gantt-zooms-container .btn .add-icon").click();
        return this;
    }

    selectLowerZoom() {
        cy.get("#gantt #gantt-zooms-container .btn .minus-icon").click();
        return this;
    }

    dragToDayIndex(title, index) {
        this.expectElementVisible(title);
        cy.get(`.gantt_task_row .gantt_task_cell:eq(${index})`).then(($el) => {
            cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).trigger('mousedown');
            cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).trigger('mousemove',{ which: 1, clientX: $el.offset().left, clientY: $el.offset().right });
            cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).trigger('mouseup');
        });
        return this;
    }

    refresh() {
        cy.reload();
        // Page.softReload();
        return this;
    }

    expectLinksToBeDisplayed(number) {
        cy.get('.gantt_task_link').should('have.length',number);
        return this;
    }

    expectElementVisible(title) {
        cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).should('have.length',1);
        // expect(element(`#gantt .gantt_container .gantt_task_line:contains('${title}')`).count()).toBe(1);
        return this;
    }

    expectLeftHandleVisibility(title, visible) {
        this.expectElementVisible(title);

        let noHandleCount = visible ? 0 : 1;
        cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}').gantt-no-left-handle`).should('have.length',noHandleCount);
        return this;
    }

    expectRightHandleVisibility(title, visible) {
        this.expectElementVisible(title);

        let noHandleCount = visible ? 0 : 1;
        cy.get(`#gantt .gantt_container .gantt_task_line:contains('${title}').gantt-no-right-handle`).should('have.length',noHandleCount);
        return this;
    }

    openTaskDetails(title, buildResult) {
        cy.get(`.gantt_task_content:contains('${title}')`).dblclick();
        return buildResult();
    }

    openManualTaskDetails(title) {
        return this.openTaskDetails(title, () => new TaskDetails());
    }

    openPhaseDetails(title) {
        cy.get(`.gantt_task_content:contains('${title}')`).dblclick();
        return new PhaseDetails();
    }

    toggleDatesColumns() {
        cy.get('#toggleIsDatesColumnsShown').click();
        return this;
    }
}


class GanttLeftPanel {
    constructor() {
        // this.leftPanel = () => "#gantt .gantt_grid_data";
    }

    expectNameDisplayed(name) {
        cy.get(`#gantt .gantt_grid_data .gantt_tree_content`).should('contain',name);
        return this;
    }

    expectStartDateDisplayed(name, date) {
        const dateFormat = {
            year: "2-digit",
            month: "numeric",
            day: "numeric"
        };
        DateFilters.expectGanttDateFilters(name,{from: date},dateFormat);
        // dates().expectValueContainingDate(`.gantt_row:contains('${name}') .gantt_cell:eq(1) input`, "shortDate", date);
        return this;
    }


    expectEndDateDisplayed(name, date) {
        const dateFormat = {
            year: "2-digit",
            month: "numeric",
            day: "numeric"
        };
        DateFilters.expectGanttDateFilters(name,{to: date},dateFormat);
        // dates().expectValueContainingDate(`.gantt_row:contains('${name}') .gantt_cell:eq(2) input`, "shortDate", date);
        return this;
    }
}
