import ReleaseGroupFlowPage from '../../../../../../../../modules/xlr-release-group-module/src/test/javascript/e2e/cypress/support/release-group-flow-page';

export default class CreateRGForm {

    constructor() {
        cy.get('h4:contains("Create new group")').should('be.visible');
        cy.url().should('contain', 'groups/create');
    }

    definitionNameIsVisible(definition) {
        cy.get(`a:contains("${definition}")`).should('be.visible');
        return this;
    }

    folderNameIsVisible(folderName) {
        cy.get(`a:contains("${folderName}")`).should('be.visible');
        return this;
    }

    setTitle(title) {
        cy.get('#release-group-properties input:nth(0)').type(title);
        return this;
    }

    setDescription(description) {
        cy.get('#release-group-properties textarea').type(description);
        return this;
    }

    saveRGProperties() {
        cy.get('button.primary:contains("Save")').click();
        return new ReleaseGroupFlowPage();
    }

}