export class InlineEditor {
    constructor(path) {
        this.path = path;
    }

    set(text) {
        this.focus();
        this.enter(text);
        return this.blur();
    }

    select(value) {
        this.focus();
        cy.get(`${this.path}`).find('select').select(value);
        return this.blur();
    }

    focus() {
        return cy.get(`${this.path} .edit-icon`).click({force: true});
    }

    clear() {
        return cy.get(`${this.path} .editable`).clear();
    }

    enter(text) {
        return cy.get(`${this.path} .editable`).type(text, {force: true});
    }

    blur() {
        return cy.get('.main-header .current-user').click({force: true});
    }

    value() {
        return cy.get(`${this.path} span:first`).then(($el) => {
            if ($el.find('span').length) {
                return cy.get(`${this.path} span:first span`).then(($el) => {
                    if ($el.find('.variable').length) {
                        return cy.get(`${this.path} span:first span`).find('.variable').invoke('text');
                    } else {
                        return cy.get(`${this.path} span:first span`).invoke('text');
                    }
                });
            } else {
                return cy.get(`${this.path} span:first`).invoke('text');
            }
        });
    }

    expectValue(title) {
        this.value().should('eq', title);
    }
}


export class AutoCompleteInlineEditor extends InlineEditor {
    set(value) {
        this.focus();
        this.enter(value);
        return this.chooseCandidate(value);
    }

    chooseCandidate(candidate) {
        return cy.get(`.ui-autocomplete:visible .ui-menu-item:contains('${candidate}')`).click();
    }
}


export class TextareaInlineEditor extends InlineEditor {
    set(text) {
        this.focus();
        this.clear();
        if (text) {
            this.enter(text);
        }
        return cy.get(`${this.path} .ok`).click();
    }
}

export class CodeInlineEditor extends InlineEditor {
    set(text) {
        this.focus();
        this.blur();
        this.enter(text);
        return cy.get(`${this.path} .ok`).click();
    }

    blur() {
        //sometimes the fullscreen is not open
        cy.get('.ace-script-editor').then($fullscreen => {
            if ($fullscreen.hasClass('full-screen')) {
                return cy.get('.ace-script-editor.full-screen .ace_text-input').type('{esc}', {force: true});
            }
        });
    }

    enter(text) {
        return cy.get(`${this.path} textarea.ace_text-input`).type(text, {force: true});
    }

    value() {
        return cy.get(`${this.path} .ace_content`);
    }

    focus() {
        cy.get(`${this.path} .display.inline-textarea`).click({force: true});
    }
}

export class UserInlineEditor extends AutoCompleteInlineEditor {
    enter(text) {
        return cy.get(`${this.path} .editable`).type(text);
    }
}

export class VariableListInlineEditor extends InlineEditor {
    focus() {
        cy.get(`${this.path} .display`).click({force: true});
    }
}

