import {TemplatePropertiesPage} from './properties-page';
import ImportTemplateDialog from "../components/import-template-dialog";

export default class AddTemplateDropdown {
    constructor(path) {
        this.path = path;
    }

    open() {
        cy.get(`${this.path} .btn-group button`).click();
        return this;
    }

    create() {
        this.open();
        cy.get(`${this.path} .dropdown-menu .create-template`).click();
        return new TemplatePropertiesPage();
    }

    move() {
        this.open();
        cy.get(`${this.path} .move-template`).click();
        return this;
    }

    import() {
        this.open();
        cy.get(`${this.path} .import-template`).click();
        return new ImportTemplateDialog();
    }
}
