export default class TaskAccessPage {
    constructor() {
        cy.get('#task-access').should('be.visible');
    }

    setTaskAvailableToAllUsers(taskType, available = true) {
        cy.get(`#task-access table tr:contains('${taskType}') input[type=checkbox]`).then(checkbox => {
            if(checkbox.is(':checked') !== available) {
                checkbox.click();
            }
        });
        return this;
    }

    save() {
        cy.get('#task-access .save').click();
        cy.get('.last-saved').should('be.visible');
        return this;
    }
}
