import TaskGenerator from './task-generator';

export default class ReleaseTask {
    constructor(taskSelector) {
        this.taskSelector = taskSelector;
    }

    delete() {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} a:contains('Delete')`).click({force: true});
        cy.get('.modal:visible .modal-header').should('contain', 'Delete Task');
        return cy.get(".modal:visible .button:contains('Delete')").click();
    }

    complete() {
        this.selectMenuItem('Complete');
        cy.get('.modal:visible .modal-body').should('contain', 'complete the task');
        cy.get('.modal:visible .button:contains("Complete")')
            .should('be.visible')
            .click();
        return this;
    }

    completeFromContextMenu() {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} a:contains('Complete')`).click();
        cy.get('.modal:visible .modal-body').should('contain', 'complete the task');
        cy.get(`.modal:visible .button:contains('Complete')`).click();
        return this;
    }

    skipFromContextMenu(comment) {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} a:contains('Skip')`).click();
        cy.get('.modal:visible .modal-body').should('contain', 'skip the task');

        cy.get('textarea[ng-model=skipComment]:visible').should('have.length', 1);
        cy.get('textarea[ng-model=skipComment]:visible').type(comment);
        cy.get(`.modal:visible .button:contains('Skip')`).click();
        return this;
    }

    lock() {
        this.selectMenuItem('Lock');
        return this;
    }

    unlock() {
        this.selectMenuItem('Unlock');
        return this;
    }

    selectMenuItem(item) {
        this.openContextMenu();
        cy.get(`#context-menu-container a:contains('${item}')`)
            .should('be.visible')
            .click();
        return this;
    }

    getNumberOfTasks() {
        return cy.get(`${this.taskSelector} .task`);
    }

    getTaskGenerator() {
        return new TaskGenerator(this.taskSelector);
    }

    openContextMenu() {
        cy.get(`${this.taskSelector} .context-menu-button`).click();
        cy.get("#context-menu-container").should('have.length', 1);
        return this;
    }

    closeContextMenu() {
        cy.get("#context-menu-container").should('have.length', 1);
        cy.get(`${this.taskSelector} .context-menu-button`).click();
        return this;
    }

    expectStartsDateTimeToBe(formattedDate, formattedTime) {
        cy.get(`${this.taskSelector} span:contains("${formattedDate} at ${formattedTime}")`).should('be.visible');
        // expect(element(By.$(`${this.task} span:contains("${formattedDate} at ${formattedTime}")`))).toBePresent();
        return this;
    }

    getTask(taskName) {
        return new ReleaseTask(`${this.taskSelector} .task:contains('${taskName}')`);
    }

    duplicate() {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} a:contains('Duplicate')`).click({force: true});
        cy.get('#context-menu-container').should('have.length', 0);
    }

    expectDuplicateEnabled() {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} .duplicate-task-button[disabled=disabled]`).should('have.length', 0);
        return cy.get(".main-header .current-user").click();
    }

    expectDeleteDisabled() {
        cy.get(`${this.taskSelector} .context-menu-button:first`).click();
        cy.get(`${this.taskSelector} .remove-task-button[disabled=disabled]`).should('have.length', 1);
        return cy.get(".main-header .current-user").click();
    }

    expectDisabledContextMenuItem(item) {
        cy.get(`#context-menu-container li:contains('${item}')`).should('have.class', 'disabled');
        return this;
    }

    expectToBeLocked() {
        cy.get(`${this.taskSelector}`)
            .closest('.task-box')
            .should('have.class', 'locked');
        return this;
    }

    expectToBeUnlocked() {
        cy.get(`${this.taskSelector}`)
            .closest('.task-box')
            .should('not.have.class', 'locked');
        return this;
    }

    expectTitleToBe(title) {
        cy.get(`${this.taskSelector} .task-title`).should('contain', title);
        return this;
    }

    expectToBeInProgress() {
        cy.get(`${this.taskSelector} .label-inprogress`).should('have.length', 1);
        return this;
    }

    expectToBeInProgress() {
        cy.get(`${this.taskSelector} .label-inprogress`).should('have.length', 1);
        return this;
    }

    expectNotFlagged() {
        cy.get(`${this.taskSelector} .flag-none-icon`).should('have.length', 0);
        return this;
    }

    expectFlaggedWith(flagName) {
        cy.get(`${this.taskSelector} .risk-flag-icon.${flagName}`).should('have.length', 1);
        return this;
    }

    expandNestedTasks() {
        cy.get(`${this.taskSelector} .task-group .link`).click();
        return this;
    }
}
