import FolderTemplatesListPage from './folder-templates-list-page';
import ReleasesListPage from './releases-list-page';
import ReleaseGroupsPage from './release-groups-page';
import {FolderDashboardsPage, FolderPermissionsPage} from './folders';
import FolderVariablesPage from './folder-variables-page';
import ConfigurationPage from './configuration-page';

export default class FolderDetailsPage {

    openTemplates() {
        cy.get(`folders-detail .a[tooltip="'Templates'"]`).click({force:true});
        return new FolderTemplatesListPage();
    }

    openReleases() {
        cy.get(`folders-detail .a[tooltip="'Releases'"]`).click();
        return new ReleasesListPage();
    }

    openGroups() {
        cy.get(`folders-detail .a[tooltip="'Groups'"]`).click();
        return new ReleaseGroupsPage();
    }

    openDashboards() {
        cy.get(`folders-detail .a[tooltip="'Dashboards'"]`).click();
        return new FolderDashboardsPage();
    }

    openFolderVariables() {
        cy.get(`folders-detail .a[tooltip="'Variables'"]`).click();
        return new FolderVariablesPage();
    }

    openPermissions() {
        cy.get(`folders-detail .a[tooltip="'Teams & Permissions'"]`).click();
        return new FolderPermissionsPage();
    }

    getPermissions() {
        return new FolderPermissionsPage();
    }

    openConfigurations() {
        cy.get(`folders-detail .a[tooltip="'Configuration'"]`).click();
        return new ConfigurationPage();
    }
}
