import {TaskDetails} from './task-details';
import {InlineEditor, TextareaInlineEditor} from '../../pages/inline-editor';
import {
    XlrInlinePasswordWithVariables,
    XlrListStringWithVariables,
    XlrMapStringStringWithVariables,
    XlrSetStringWithVariables
} from '../xlr-input-with-variables';

export class CustomScriptDetails extends TaskDetails {

    groupPath(field) {
        return `#resizable-modal #${field}`;
    }

    setIntegerField(field, value) {
        new FormHelper().enter(`#${field} input`, value);
        return this;
    }

    setSelectField(field, value) {
        new InlineEditor(this.editorPath(field)).select(value);
        return this;
    }

    setTextField(field, value) {
        new InlineEditor(this.editorPath(field)).set(value);
        return this;
    }

    setTextAreaField(field, value) {
        new TextareaInlineEditor(this.editorPath(field)).set(value);
        return this;
    }

    setAutocompleteField(field, value) {
        cy.get(`#resizable-modal #${field} input`).scrollIntoView();
        cy.get(`#resizable-modal #${field} input:visible`).click();
        cy.get(`ul.xl-components.xl-widget-autocomplete li:contains('${value}')`).click();
        return this;
    }

    typeAutocompleteField(field, value) {
        cy.get(`#resizable-modal #${field} .xl-autocomplete-enabled-btn`).click();
        cy.get(`#resizable-modal #${field} .xl-widget-autocomplete input`).type(value);
        return this;
    }

    getValue(field) {
        return new InlineEditor(this.editorPath(field)).value();
    }

    editorPath(field) {
        return `#resizable-modal #${field} .field`;
    }

    getStringMapField(field) {
        return new XlrMapStringStringWithVariables(this.groupPath(field));
    }

    getStringListField(field) {
        return new XlrListStringWithVariables(this.groupPath(field));
    }

    getStringSetField(field) {
        return new XlrSetStringWithVariables(this.groupPath(field));
    }

    getPasswordField(field) {
        return new XlrInlinePasswordWithVariables(this.groupPath(field));
    }

    close() {
        cy.get('.modal button.close').click();
        return this;
    }

    expectOutputVarHelpText(expected) {
        cy.get("#outputVarHelpText").should('have.text', expected);
        return this;
    }

    expectOutputValueToContain(field, value) {
        cy.get(`#${field} .field-readonly span`).then((el) => expect(el.text()).to.contain(value));
        return this;
    }

    expectOutputValueToBe(field, value) {
        cy.get(`#${field} .field-readonly span`).then((el) => expect(el.text()).to.match(new RegExp(value)));
        return this;
    }

    expectOutputValueToReallyBe(field, value) {
        cy.get(`#${field} .field-readonly span`).then((el) => expect(el).to.have.text(value));
        return this;
    }

}