import {XlWidgetAutocomplete} from "../components/xl-components";
import {InlineEditor} from "./inline-editor";
import ReleasesListPage from "./releases-list-page";
import _ from 'lodash';

export default class TriggersPage {
    constructor() {
        this.listSelector = "#triggers";
    }

    setAllowConcurrentReleasesFromTriggerAndSubmit(checked) {
        let checkbox = element(By.css('#templateForm-allowConcurrentReleasesFromTrigger'));
        if (checkbox.getAttribute('checked') !== checked) {
            checkbox.click();
        }
        element(By.css('#templateForm-save')).click();
        return this;
    }

    expectAllowConcurrentReleasesFromTrigger(expectedValue) {
        let selector = '#templateForm-allowConcurrentReleasesFromTrigger';
        if (expectedValue) {
            selector += ":checked";
        } else {
            selector += ":not(:checked)";
        }

        expect(element.all(By.$(selector)).count() !== 0).toBeTruthy();
        return this;
    }

    newTrigger(type) {
        cy.get(`.trigger-types`).select(type);
        return new TriggerEditPage();
    }

    expectNoNewTriggerDropdownShown() {
        expect(element(By.$(".trigger-types"))).toBePresent(false);
        return this;
    }

    deleteTrigger(title) {
        let rowSelector = `${this.listSelector} tr:contains('${title}')`;
        element(By.$(`${rowSelector} .close-icon:last`)).click();
        expect(element(By.$(rowSelector)).isPresent()).toBe(false);
        return this;
    }

    editTrigger(title) {
        element(By.$(`${this.listSelector} .link:contains('${title}')`)).click();
        return new TriggerEditPage();
    }

    checkTriggerTitle(expectedTitle) {
        expect(element(By.$(`${this.listSelector} .link:contains('${expectedTitle}')`)).getText()).toEqual(expectedTitle);
        return this;
    }

    openTriggerTypes() {
        element(By.$(".trigger-types")).click();
        return this;
    }

    goOnRelatedReleasesOf(triggerName) {
        let rowSelector = `${this.listSelector} tr:contains('${triggerName}')`;
        cy.get(`${rowSelector} .open-related-release .link`).click();
        return new ReleasesListPage();
    }
}

class TriggerEditPage {

    constructor() {
        this.formSelector = "[name='triggerForm']";
    }

    fillFormAndSubmit(fields) {
        this.fillForm(fields);
        return this.submit();
    }

    getAutocomplete(field) {
        return new XlWidgetAutocomplete(`#${field}`);
    }

    fillAutocompleteField(field, value) {
        this.getAutocomplete(field).focus().select(value, true);
        browser.actions().sendKeys(protractor.Key.ENTER).perform();
        return this;
    }

    fillSelectField(field, value) {
        new InlineEditor(`${formSelector} #${field}`).select(value);
        return this;
    }

    fillVariable(variable, value) {
        let editor = new InlineEditor(`div.form-group:contains(${variable})`);
        editor.set(value);
        return this;
    }

    setEnabled(value) {
        element(By.$(`${formSelector} #enabled`)).isSelected().then(function (selected) {
            if (selected !== value) {
                return element(By.$(`${formSelector} #enabled`)).click();
            }
        });
        return this;
    }

    fillForm(fields) {
        if (fields instanceof Object) {
            for (let k in fields) {
                let v = fields[k];
                if (_.isNumber(v)) {
                    cy.get(`${this.formSelector} #${k}`).clear();
                    cy.get(`${this.formSelector} #${k}`).type(`${v}`);
                } else {
                    cy.get(`${this.formSelector} #${k}`).clear();
                    cy.get(`${this.formSelector} #${k}`).type(`${v}`);
                }
            }
        }
        return this;
    }

    submit() {
        cy.get(`#release-header #submit`).click();
        return new TriggersPage();
    }
}
