export default class ProfilePage {
    constructor() {
        cy.get('#profileForm').should('be.visible');
    }

    expectEmailDefined(email) {
        cy.get('#email').should('have.value', email);
        return this;
    }

    expectFullNameDefined(fullName) {
        cy.get('#full-name').should('have.value', fullName);
        return this;
    }

    expectNoEmailDefined() {
        this.expectEmailDefined('');
        return this;
    }

    expectNoFullNameDefined() {
        this.expectFullNameDefined('');
        return this;
    }

    expectPasswordNotToBe(password) {
        cy.get('#password').should('not.have.value', password);
        return this;
    }

    expectDateFormatToBe(dateFormat) {
        cy.get('select[ng-model="$ctrl.profile.dateFormat"]').should('have.value', dateFormat);
        return this;
    }

    expectTimeFormatToBe(timeFormat) {
        cy.get('select[ng-model="$ctrl.profile.timeFormat"]').should('have.value', timeFormat);
        return this;
    }

    expectFirstDayOfWeekToBe(firstDayOfWeek) {
        cy.get('select[ng-model="$ctrl.profile.firstDayOfWeek"]').should('have.value', firstDayOfWeek);
        return this;
    }

    save() {
        cy.get('#profile .save:enabled').click();
        cy.get('.last-saved').should('be.visible');
        // element(By.$('#profile .save:enabled')).click();
        // Browser.waitFor('.last-saved');
        return this;
    }


    setEmail(email) {
        cy.get('#email').type(email);
        return this.save();
    }

    setFullName(fullName) {
        cy.get('#full-name').type(fullName);
        return this.save();
    }

    setPassword(previousPassword, password) {
        cy.get('#previousPassword').type(previousPassword);
        cy.get('#password').type(password);
        cy.get('#passwordConfirmation').type(password);
        return this.save();
    }

    setDateFormat(dateFormat) {
        cy.get(`.form-group:contains('Date format') select`).select(dateFormat);
        return this.save();
    }

    setTimeFormat(timeFormat) {
        cy.get(`.form-group:contains('Time format') select`).select(timeFormat);
        return this.save();
    }

    setFirstDayOfWeek(firstDayOfWeek) {
        cy.get(`.form-group:contains('First day of week') select`).select(firstDayOfWeek);
        return this.save();
    }

    refresh() {
        cy.reload();
        return new ProfilePage();
    }
}