import {ReleasePropertiesPage, TemplatePropertiesPage} from './release-properties-page';
import ReleasePage from './release-page';
import Page from './page';
import TagEditor from '../components/tag-editor';
import ImportTemplateDialog from "../components/import-template-dialog";

export default class TemplatesListPage {
    constructor() {
        cy.get('#templates').should('be.visible');
    }

    openTemplateByName(templateName) {
        cy.doWithRetry(
            () => cy.get(`.template:contains('${templateName}') .raised-link`).click(),
            '#release-content:visible');
        return new ReleasePage();
    }

    createNewTemplate() {
        cy.get(".new-template").click();
        return new TemplatePropertiesPage();
    }

    newReleaseFromTemplate(templateName) {
        cy.get(`.template:contains('${templateName}') a:contains('New release')`).click();
        return new ReleasePropertiesPage();
    }

    openImportTemplateDialog() {
        cy.get(".import-template").click();
        return new ImportTemplateDialog();
    }

    setSearchFilter(filterText) {
        cy.get('.searchFilter').type(filterText);
        return this;
    }

    addSearchTags(tags) {
        tags.forEach(tag => {
            new TagEditor('.tags-input').addTag(tag);
        });
        return this;
    }

    copy(originTitle, targetTitle) {
        cy.get(`.template:contains('${originTitle}') .copy`).click();
        cy.get('ctrl.copyOfTemplate.title').type(targetTitle);
        cy.get('ctrl.copyOfTemplate.description').type('description');
        cy.get('.modal:visible .continue').click();
        new TemplatePage();
    }

    delete(title) {
        Page.openTemplatesListManually();
        cy.get(`.template:contains('${title}') .delete`).click();
        cy.get('.modal:visible .continue').click();
    }

    expectTemplatesDisplayed(templates) {
        for (let title in templates) {
            let expected = templates[title];
            let expectedCount = 0 + !!expected.displayed;
            cy.get(`.template:contains('${title}')`).should('have.length', expectedCount);
        }
        return this;
    }

    expectContextMenuDisplayed(isDisplayed) {
        cy.get('.context-menu-button').should('have.length', isDisplayed ? 1 : 0);
        return this;
    }

    expectMetaInformationModalDisplayed(isDisplayed, title) {
        cy.get('.context-menu-button').click();
        cy.get("#context-menu-container").should('have.length', isDisplayed ? 1: 0);
        cy.get('a:contains("Meta information")').click({force: true});
        cy.get('.modal:visible .modal-header').should('contain', `Meta information - ${title}`);
        return this;
    }
}

export class TemplatePage {
    constructor() {
    }

    static copy(originTitle, targetTitle) {
        this.originTitle = originTitle;
        this.targetTitle = targetTitle;
        Page.openTemplatesListManually()
            .setSearchFilter(this.originTitle);
        cy.get(`.template`).should('have.length',1); // wait till the display is filtered before opening the copy modal since UI refreshes and copy modal gets closed
        cy.get(`.template:contains('${this.originTitle}') .copy`).click();
        cy.get('input[ng-model="ctrl.copyOfTemplate.title"]').clear().type(this.targetTitle);
        cy.get('textarea[ng-model="ctrl.copyOfTemplate.description"]').clear().type('description');
        cy.get('.modal:visible .continue').click();
        new TemplatePage();
        return Page.openTemplatesListManually();
    }

    static delete(title) {
        this.title = title;
        Page.openTemplatesListManually();
        cy.get(`.template:contains('${this.title}') .delete`).click();
        return cy.get('.modal:visible .continue').click();
    }
}


