import {InlineEditor} from '../pages/inline-editor';
import {XlrListStringWithVariables} from "../components/xlr-input-with-variables";

import _ from 'lodash';


export class VariablesEditor {
    constructor(path) {
        cy.wait(1000);
        this.path = path;
        cy.get(this.path).scrollIntoView().should('be.visible');
    }

    expectVariablesDisplayed(variables, expected) {
        cy.get(`${this.path} .form-group`).should('have.length', variables.length);

        cy.get(`${this.path}`).within(elements => {
                _.zip(variables, elements).forEach(([variable, item], index) => {
                    cy.get('.form-group').eq(index).find('label span.ng-binding').invoke('text').then((labelText) => {
                        expect(labelText).to.eq(variable.name);
                    });

                    if (expected) {
                        if (variable.isDropDownList) {
                            // it can be either select or, when it is not focused - just a div
                            cy.doWithRetry(
                                () => {},
                                [
                                    () => {
                                        debugger;
                                        expect(Cypress.$(`${this.path} .form-group`).eq(index).find('select')).to.have.value(`string:${variable.value}`);
                                    },
                                    () => expect(Cypress.$(`${this.path} .form-group`).eq(index).find('div.display').text()).to.contain(`${variable.value}`)
                                ]
                            );
                        } else {
                            cy.get('.form-group').eq(index).find('input').should('have.value', variable.value);
                        }
                    } else {
                        cy.get('.form-group').eq(index).find('.field-readonly.read-only span').invoke('text').then((readOnlyValue) => {
                            expect(readOnlyValue).to.eq(variable.value);
                        });
                    }
                });
            }
        );
        return this;
    }

    setVariableValue(key, value) {
        new InlineEditor(`${this.path} .form-group:contains('${key}') div[inline-text-editor]`)
            .set(value);
        return this;
    }

    getStringListField(key) {
        return new XlrListStringWithVariables(`${this.path} #${key}`);
    }
}


global.VariablesEditor = VariablesEditor;