const selectRoleRow = roleName => {
    const locator = By.$(`tr:contains('${roleName}')`);
    browser.wait(EC.visibilityOf(element(locator), 3000));
    return element(locator);
};

const populatePrincipalField = principalNames => principalNames.forEach(p => {
    const input = cy.get('.tag-input').first();
    // const input = element.all(By.css('.tag-input')).first();
    input.click();
    input.type(p);
    input.type('{enter}');
});

const removeExistingPrincipals = () => cy.get('.tags .tag-close').then(p => p.click());


export default class RolesPage {
    constructor() {
        cy.get('#roles .roles-table').should('be.visible');
        // Browser.waitFor('#roles .roles-table');
    }

    addNewRole(roleName, principalNames) {
        cy.get('.new-role').click();
        // element(By.css('.new-role')).click();
        // Browser.waitFor('.modal-body');
        cy.get('.modal-body').should('be.visible');
        cy.get('#rolename').type(roleName);
        // element(By.css('#rolename')).sendKeys(roleName);
        populatePrincipalField(principalNames);
        cy.get('.save').click();
        // element(By.css('.save')).click();
        return this;
    }

    removeRole(roleName) {
        const row = selectRoleRow(roleName);
        row.element(By.css('.remove-action')).click();
        Browser.waitFor('.modal-body');
        element(By.css('.modal-footer .primary')).click();
        return this;
    }

    editRole(roleName, principalNames) {
        const row = selectRoleRow(roleName);
        row.element(By.$(`.action:contains('Edit role')`)).click();
        Browser.waitFor('.modal-body');
        removeExistingPrincipals();
        populatePrincipalField(principalNames);
        element(By.css('.save')).click();
        return this;
    }

    expectListHasRole(roleName, principalNames) {
        browser.sleep(1000);
        const row = selectRoleRow(roleName);
        const principals = row.all(By.css('.tag-label'));
        expect(principals.count()).toBe(principalNames.length);
        principalNames.forEach(name => {
            expect(principals.getText()).toContain(name);
        });
        return this;
    }
}
